/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.RequestSyncBookStatesMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public class BookUnlockStateManager {
    private static final BookUnlockStateManager instance = new BookUnlockStateManager();
    private final Set<UUID> syncRequestedPlayers = new ObjectLinkedOpenHashSet();
    private final Set<UUID> advancementUpdateRequestedPlayers = new ObjectLinkedOpenHashSet();
    private final Object2LongArrayMap<UUID> lastAdvancementUpdateRequests = new Object2LongArrayMap();
    public BookStatesSaveData saveData;
    private boolean wasLoaded = false;

    public static BookUnlockStateManager get() {
        return instance;
    }

    private BookUnlockStates getStateFor(class_1657 player) {
        this.getSaveDataIfNecessary(player);
        return this.saveData.getUnlockStates(player.method_5667());
    }

    public String getUnlockCodeFor(class_1657 player, Book book) {
        return this.getStateFor(player).getUnlockCode(book);
    }

    public Book applyUnlockCodeFor(class_3222 player, String unlockCode) {
        Book book = this.getStateFor((class_1657)player).applyUnlockCode(unlockCode);
        if (book != null) {
            this.saveData.method_80();
            this.syncFor(player);
        }
        return book;
    }

    public void syncFor(class_3222 player) {
        Services.NETWORK.sendTo(player, new SyncBookUnlockStatesMessage(this.getStateFor((class_1657)player)));
    }

    public void updateAndSyncFor(class_3222 player) {
        if (BookDataManager.get().areBooksBuilt()) {
            this.getStateFor((class_1657)player).update(player);
            this.saveData.method_80();
            this.syncFor(player);
        } else {
            this.syncRequestedPlayers.add(player.method_5667());
            this.wasLoaded = false;
        }
    }

    public List<class_2960> getBooksFor(class_1657 player) {
        return this.getStateFor(player).getBooks();
    }

    public void resetFor(class_3222 player, Book book) {
        this.getStateFor((class_1657)player).reset(book);
        this.saveData.method_80();
        this.syncFor(player);
    }

    public boolean isUnlockedFor(class_1657 player, BookCategory category) {
        return this.getStateFor(player).isUnlocked(category);
    }

    public boolean isUnlockedFor(class_1657 player, BookEntry entry) {
        return this.getStateFor(player).isUnlocked(entry);
    }

    public boolean isUnlockedFor(class_1657 player, BookPage page) {
        return this.getStateFor(player).isUnlocked(page);
    }

    public List<BookPage> getUnlockedPagesFor(class_1657 player, BookEntry entry) {
        return this.getStateFor(player).getUnlockedPagesIn(entry);
    }

    public boolean isReadFor(class_1657 player, BookEntry entry) {
        return this.getStateFor(player).isRead(entry);
    }

    public boolean canRunFor(class_1657 player, BookCommand command) {
        return this.getStateFor(player).canRun(command);
    }

    public void setRunFor(class_1657 player, BookCommand command) {
        this.getStateFor(player).setRun(command);
    }

    public boolean readFor(class_3222 player, BookEntry entry) {
        return this.getStateFor((class_1657)player).read(entry, player);
    }

    public void onAdvancement(class_3222 player) {
        long lastAdvancementUpdateRequest = this.lastAdvancementUpdateRequests.getOrDefault((Object)player.method_5667(), 0L);
        this.lastAdvancementUpdateRequests.put((Object)player.method_5667(), player.method_51469().method_8510());
        if (player.method_51469().method_8510() - lastAdvancementUpdateRequest > 100L) {
            this.updateAndSyncFor(player);
        } else {
            this.advancementUpdateRequestedPlayers.add(player.method_5667());
        }
    }

    private void getSaveDataIfNecessary(class_1657 player) {
        if (this.saveData == null) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.saveData = (BookStatesSaveData)serverPlayer.method_51469().method_8503().method_30002().method_17983().method_17924(BookStatesSaveData.TYPE);
            } else {
                this.saveData = new BookStatesSaveData();
                Services.NETWORK.sendToServer(RequestSyncBookStatesMessage.INSTANCE);
                Modonomicon.LOG.error("Tried to get Modonomicon save data for player on client side, but was not set. This should not happen. Requesting a sync from the server. Please re-open the book in a few seconds to see your progress.");
            }
        }
    }

    public void onServerTickEnd(MinecraftServer server) {
        this.handleSyncRequestedPlayers(server);
        this.handleAdvancementUpdateRequestedPlayers(server);
    }

    public void handleAdvancementUpdateRequestedPlayers(MinecraftServer server) {
        if (server.method_3780() % 100 != 0) {
            return;
        }
        if (!this.advancementUpdateRequestedPlayers.isEmpty()) {
            class_3324 list = server.method_3760();
            for (UUID id : this.advancementUpdateRequestedPlayers) {
                class_3222 player = list.method_14602(id);
                if (player == null) continue;
                this.updateAndSyncFor(player);
            }
            this.advancementUpdateRequestedPlayers.clear();
        }
    }

    public void handleSyncRequestedPlayers(MinecraftServer server) {
        if (server.method_3780() % 100 != 0) {
            return;
        }
        boolean newState = BookDataManager.get().areBooksBuilt();
        if (newState != this.wasLoaded) {
            if (!this.wasLoaded && !this.syncRequestedPlayers.isEmpty()) {
                class_3324 list = server.method_3760();
                for (UUID id : this.syncRequestedPlayers) {
                    class_3222 player = list.method_14602(id);
                    if (player == null) continue;
                    this.updateAndSyncFor(player);
                }
                this.syncRequestedPlayers.clear();
            }
            this.wasLoaded = newState;
        }
    }
}

