/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.fluid;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.fluid.FabricFluidHolder;
import com.klikli_dev.modonomicon.platform.services.FluidHelper;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;

public class FluidRenderHelper {
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;

    public static void drawFluid(class_332 guiGraphics, int width, int height, FabricFluidHolder fluidHolder, int capacity, int x, int y) {
        FluidVariant fluidVariant = fluidHolder.toVariant();
        class_3611 fluid = (class_3611)fluidHolder.getFluid().comp_349();
        if (fluid.method_15780(class_3612.field_15906)) {
            return;
        }
        FluidRenderHelper.getStillFluidSprite(fluidVariant).ifPresent(fluidStillSprite -> {
            int fluidColor = FluidRenderHelper.getColorTint(fluidVariant);
            int amount = fluidHolder.getAmount();
            int scaledAmount = amount * height / capacity;
            if (amount > 0 && scaledAmount < 1) {
                scaledAmount = 1;
            }
            if (scaledAmount > height) {
                scaledAmount = height;
            }
            GuiGraphicsExt.drawTiledSprite(guiGraphics, width, height, fluidColor, scaledAmount, fluidStillSprite, x, y);
        });
    }

    private static int getColorTint(FluidVariant fluidVariant) {
        int fluidColor = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        return fluidColor | 0xFF000000;
    }

    private static Optional<class_1058> getStillFluidSprite(FluidVariant fluidVariant) {
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        return Optional.ofNullable(sprite);
    }

    public static List<class_2561> getTooltip(FabricFluidHolder fluidHolder, int capacity, class_1836 tooltipFlag, FluidHelper.TooltipMode tooltipMode) {
        FluidVariant variant = fluidHolder.toVariant();
        class_3611 fluidType = (class_3611)fluidHolder.getFluid().comp_349();
        try {
            if (fluidType.method_15780(class_3612.field_15906)) {
                return new ArrayList<class_2561>();
            }
            List tooltip = FluidVariantRendering.getTooltip((FluidVariant)variant);
            long amount = fluidHolder.getAmount();
            long milliBuckets = amount * 1000L / 1000L;
            if (tooltipMode == FluidHelper.TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
                class_5250 amountString = class_2561.method_43469((String)"tooltip.modonomicon.fluid.amount_and_capacity", (Object[])new Object[]{milliBuckets, capacity});
                tooltip.add(amountString.method_27692(class_124.field_1080));
            } else if (tooltipMode == FluidHelper.TooltipMode.SHOW_AMOUNT) {
                class_5250 amountString = class_2561.method_43469((String)"tooltip.modonomicon.fluid.amount", (Object[])new Object[]{milliBuckets});
                tooltip.add(amountString.method_27692(class_124.field_1080));
            }
            return tooltip;
        }
        catch (RuntimeException e) {
            class_2561 displayName = FluidVariantAttributes.getName((FluidVariant)variant);
            Modonomicon.LOG.error("Failed to get tooltip for fluid: " + String.valueOf(displayName), (Throwable)e);
            return new ArrayList<class_2561>();
        }
    }
}

