/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.bookmarks;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.EntryListButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11908;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_7225;

public class BookBookmarksScreen
extends BookPaginatedScreen {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    protected final List<class_4185> entryButtons = new ArrayList<class_4185>();
    protected final BookParentScreen parentScreen;
    private final List<BookAddress> visibleEntries = new ArrayList<BookAddress>();
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<BookAddress> allEntries;
    private BookTextHolder infoText;
    private List<class_2561> tooltip;

    public BookBookmarksScreen(BookParentScreen parentScreen) {
        super((class_2561)class_2561.method_43471((String)"modonomicon.gui.bookmarks.screen.title"));
        this.parentScreen = parentScreen;
        this.infoText = new BookTextHolder("modonomicon.gui.bookmarks.info");
    }

    public void handleButtonEntry(class_4185 button) {
        if (button instanceof EntryListButton) {
            EntryListButton entry = (EntryListButton)button;
            if (!BookUnlockStateManager.get().isUnlockedFor((class_1657)class_310.method_1551().field_1724, entry.getEntry())) {
                return;
            }
            this.method_25419();
            if (entry.getAddressToOpen() != null) {
                BookGuiManager.get().openBook(entry.getAddressToOpen());
            } else {
                BookGuiManager.get().openEntry(entry.getEntry().getBook().getId(), entry.getEntry().getId(), 0);
            }
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.infoText.hasComponent()) {
            this.infoText = new RenderedBookTextHolder(this.infoText, textRenderer.render(this.infoText.getString()));
        }
    }

    public void drawCenteredStringNoShadow(class_332 guiGraphics, class_2561 s, int x, int y, int color) {
        this.drawCenteredStringNoShadow(guiGraphics, s, x, y, color, 1.0f);
    }

    public void drawCenteredStringNoShadow(class_332 guiGraphics, class_2561 s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.field_22793.method_27525((class_5348)s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.field_22793);
        GuiGraphicsExt.drawString(guiGraphics, this.field_22793, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public BookParentScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.parentScreen.getBook());
            }
        }
    }

    protected void drawTooltip(class_332 guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.method_71274(this.tooltip.stream().map(class_2561::method_30937).toList(), pMouseX, pMouseY);
        }
    }

    protected void onPageChanged() {
        this.createEntryList();
    }

    protected void resetTooltip() {
        this.tooltip = null;
    }

    private void createEntryList() {
        this.entryButtons.forEach(b -> {
            this.field_33816.remove(b);
            this.method_25396().remove(b);
            this.field_33815.remove(b);
        });
        this.entryButtons.clear();
        this.visibleEntries.clear();
        this.visibleEntries.addAll(this.allEntries);
        this.maxOpenPagesIndex = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxOpenPagesIndex += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.openPagesIndex;
        }
        if (this.openPagesIndex == 0) {
            this.addEntryButtons(138, 35, 0, 11);
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(12, 15, start, 13);
            this.addEntryButtons(138, 15, start + 13, 13);
        }
    }

    private int getEntryCountStart() {
        if (this.openPagesIndex == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.openPagesIndex - 1);
    }

    @Override
    public void setTooltip(List<class_2561> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Book getBook() {
        return this.parentScreen.getBook();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.resetTooltip();
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)this.bookLeft, (float)this.bookTop);
        BookContentRenderer.renderBookBackground(guiGraphics, this.getBook().getBookContentTexture());
        if (this.openPagesIndex == 0) {
            this.drawCenteredStringNoShadow(guiGraphics, this.method_25440(), 74, 15, this.parentScreen.getBook().getDefaultTitleColor());
            this.drawCenteredStringNoShadow(guiGraphics, (class_2561)class_2561.method_43471((String)"modonomicon.gui.bookmarks.entry_list_title"), 203, 15, this.parentScreen.getBook().getDefaultTitleColor());
            BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 74, 27);
            BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 203, 27);
            BookPageRenderer.renderBookTextHolder(guiGraphics, this.infoText, this.field_22793, 12, 37, 124, 118);
        }
        if (this.visibleEntries.isEmpty()) {
            this.drawCenteredStringNoShadow(guiGraphics, (class_2561)class_2561.method_43471((String)"modonomicon.gui.bookmarks.no_results"), 203, 80, 0x333333);
        }
        guiGraphics.method_51448().popMatrix();
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    public void method_25419() {
        ClientServices.GUI.popGuiLayer();
    }

    @Override
    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 257 && this.visibleEntries.size() == 1) {
            BookAddress entry = this.visibleEntries.get(0);
            this.method_25419();
            BookGuiManager.get().openBook(entry);
            return true;
        }
        return super.method_25404(event);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        BookTextRenderer textRenderer = new BookTextRenderer(this.getBook(), (class_7225.class_7874)this.field_22787.field_1687.method_30349());
        this.prerenderMarkdown(textRenderer);
        this.allEntries = BookVisualStateManager.get().getBookmarksFor((class_1657)this.field_22787.field_1724, this.getBook());
        this.createEntryList();
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            BookAddress address = this.visibleEntries.get(start + i);
            EntryListButton button = new EntryListButton(this.getBook().getEntry(address.entryId()), address, this.bookLeft + x, this.bookTop + y + i * 11, this::handleButtonEntry);
            this.method_37063((class_364)button);
            this.entryButtons.add(button);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

