/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_1144;
import net.minecraft.class_11719;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class EntryListButton
extends class_4185 {
    private static final int ANIM_TIME = 5;
    private final BookEntry entry;
    @Nullable
    private final BookAddress addressToOpen;
    private float timeHovered;

    public EntryListButton(BookEntry entry, int pX, int pY, class_4185.class_4241 pOnPress) {
        this(entry, null, pX, pY, pOnPress);
    }

    public EntryListButton(BookEntry entry, @Nullable BookAddress addressToOpen, int pX, int pY, class_4185.class_4241 pOnPress) {
        super(pX, pY, 124, 10, (class_2561)class_2561.method_43471((String)entry.getName()), pOnPress, class_4185.field_40754);
        this.entry = entry;
        this.addressToOpen = addressToOpen;
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    @Nullable
    public BookAddress getAddressToOpen() {
        return this.addressToOpen;
    }

    private int getEntryColor() {
        return -16777216;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22763) {
            this.timeHovered = this.method_49606() ? Math.min(5.0f, this.timeHovered + ClientTicks.delta) : Math.max(0.0f, this.timeHovered - ClientTicks.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.method_49606() ? partialTicks : -partialTicks)));
            float widthFract = time / 5.0f;
            boolean locked = !BookUnlockStateManager.get().isUnlockedFor((class_1657)class_310.method_1551().field_1724, this.entry);
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().scale(0.5f, 0.5f);
            guiGraphics.method_25294(this.method_46426() * 2, this.method_46427() * 2, (this.method_46426() + (int)((float)this.field_22758 * widthFract)) * 2, (this.method_46427() + this.field_22759) * 2, 0x22000000);
            if (locked) {
                int color = class_9848.method_61318((float)0.7f, (float)1.0f, (float)1.0f, (float)1.0f);
                BookContentRenderer.drawLock(guiGraphics, this.entry.getBook(), this.method_46426() * 2 + 2, this.method_46427() * 2 + 2, color);
            } else {
                this.entry.getIcon().render(guiGraphics, this.method_46426() * 2 + 2, this.method_46427() * 2 + 2);
            }
            guiGraphics.method_51448().scale(2.0f, 2.0f);
            guiGraphics.method_51448().popMatrix();
            class_5250 name = locked ? class_2561.method_43471((String)"modonomicon.gui.search.entry.locked") : class_2561.method_43471((String)this.entry.getName());
            name.method_27694(style -> style.method_27704((class_11719)new class_11719.class_11721(BookDataManager.Client.get().safeFont(this.entry.getBook().getFont()))));
            int x = this.method_46426() + 12;
            int y = this.method_46427() + 2;
            int maxWidth = 112;
            guiGraphics.method_51448().pushMatrix();
            float scale = Math.min(1.0f, (float)maxWidth / (float)class_310.method_1551().field_1772.method_27525((class_5348)name));
            if (scale < 1.0f) {
                guiGraphics.method_51448().translate((float)x - (float)x * scale, (float)y - (float)y * scale);
                guiGraphics.method_51448().scale(scale, scale);
            }
            guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)name, x, y, this.getEntryColor(), false);
            guiGraphics.method_51448().popMatrix();
        }
    }

    public void method_25354(class_1144 soundHandlerIn) {
        if (this.entry != null) {
            // empty if block
        }
    }
}

