/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry;

import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import net.minecraft.class_11909;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import org.jetbrains.annotations.Nullable;

public class BookEntryDoublePageScreen
extends BookEntryScreen {
    private BookPage leftPage;
    private BookPage rightPage;
    private BookPageRenderer<?> leftPageRenderer;
    private BookPageRenderer<?> rightPageRenderer;

    public BookEntryDoublePageScreen(BookParentScreen parentScreen, BookContentEntry entry) {
        super(parentScreen, entry);
    }

    @Override
    protected int getOpenPagesIndexForPage(int pageIndex) {
        for (int i = 0; i < this.unlockedPages.size(); ++i) {
            int pageNumber = ((BookPage)this.unlockedPages.get(i)).getPageNumber();
            if (pageNumber == pageIndex) {
                return i & 0xFFFFFFFE;
            }
            if (pageNumber > pageIndex) break;
        }
        return 0;
    }

    @Override
    protected int getPageForOpenPagesIndex(int openPagesIndex) {
        return openPagesIndex / 2;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 2 < this.unlockedPages.size();
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? (this.openPagesIndex -= 2) : (this.openPagesIndex += 2);
            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.getBook());
            }
        }
    }

    @Override
    @Nullable
    public class_2583 getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        class_2583 leftPageClickedStyle = this.getClickedComponentStyleAtForPage(this.leftPageRenderer, pMouseX, pMouseY);
        if (leftPageClickedStyle != null) {
            return leftPageClickedStyle;
        }
        return this.getClickedComponentStyleAtForPage(this.rightPageRenderer, pMouseX, pMouseY);
    }

    @Override
    protected boolean mouseClickedPage(class_11909 event, boolean isDoubleClick) {
        return this.clickPage(this.leftPageRenderer, event, isDoubleClick) || this.clickPage(this.rightPageRenderer, event, isDoubleClick);
    }

    @Override
    protected void beginDisplayPages() {
        if (this.leftPageRenderer != null) {
            this.leftPageRenderer.onEndDisplayPage(this);
        }
        if (this.rightPageRenderer != null) {
            this.rightPageRenderer.onEndDisplayPage(this);
        }
        int leftPageIndex = this.openPagesIndex;
        int rightPageIndex = leftPageIndex + 1;
        this.leftPage = leftPageIndex < this.unlockedPages.size() ? (BookPage)this.unlockedPages.get(leftPageIndex) : null;
        BookPage bookPage = this.rightPage = rightPageIndex < this.unlockedPages.size() ? (BookPage)this.unlockedPages.get(rightPageIndex) : null;
        if (this.leftPage != null) {
            this.leftPageRenderer = PageRendererRegistry.getPageRenderer(this.leftPage.getType()).create(this.leftPage);
            this.leftPageRenderer.onBeginDisplayPage(this, 12, 15);
        } else {
            this.leftPageRenderer = null;
        }
        if (this.rightPage != null) {
            this.rightPageRenderer = PageRendererRegistry.getPageRenderer(this.rightPage.getType()).create(this.rightPage);
            this.rightPageRenderer.onBeginDisplayPage(this, 141, 15);
        } else {
            this.rightPageRenderer = null;
        }
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.resetTooltip();
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)this.bookLeft, (float)this.bookTop);
        BookContentRenderer.renderBookBackground(guiGraphics, this.bookContentTexture);
        guiGraphics.method_51448().popMatrix();
        guiGraphics.method_71048();
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)this.bookLeft, (float)this.bookTop);
        this.renderPage(guiGraphics, this.leftPageRenderer, pMouseX, pMouseY, pPartialTick);
        this.renderPage(guiGraphics, this.rightPageRenderer, pMouseX, pMouseY, pPartialTick);
        guiGraphics.method_51448().popMatrix();
        guiGraphics.method_71048();
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }
}

