/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.index;

import com.klikli_dev.modonomicon.api.events.EntryClickedEvent;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.CategoryVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.EntryListButton;
import com.klikli_dev.modonomicon.client.gui.book.entry.EntryDisplayState;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.events.ModonomiconEvents;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_7919;

public class BookCategoryIndexScreen
extends BookPaginatedScreen
implements BookCategoryScreen {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    protected final List<class_4185> entryButtons = new ArrayList<class_4185>();
    protected final BookParentScreen parentScreen;
    protected final BookCategory category;
    private final List<BookEntry> visibleEntries = new ArrayList<BookEntry>();
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<BookEntry> allEntries;
    private List<class_2561> tooltip;

    public BookCategoryIndexScreen(BookParentScreen parentScreen, BookCategory category) {
        this(parentScreen, category, true);
    }

    public BookCategoryIndexScreen(BookParentScreen parentScreen, BookCategory category, boolean addExitButton) {
        super((class_2561)class_2561.method_43471((String)category.getName()), addExitButton);
        this.parentScreen = parentScreen;
        this.category = category;
    }

    public void handleEntryListButton(class_4185 button) {
        BookEntry entry = ((EntryListButton)button).getEntry();
        EntryDisplayState displayStyle = this.getEntryDisplayState(entry);
        EntryClickedEvent event = new EntryClickedEvent(this.category.getBook().getId(), entry.getId(), new class_11909((double)button.method_46426(), (double)button.method_46427(), new class_11910(0, 0)), displayStyle);
        if (ModonomiconEvents.client().entryClicked(event)) {
            return;
        }
        BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
    }

    protected void drawTitle(class_332 guiGraphics, int x, int y) {
        guiGraphics.method_51448().pushMatrix();
        float scale = Math.min(1.0f, 120.0f / (float)this.field_22793.method_27525((class_5348)this.method_25440()));
        if (scale < 1.0f) {
            guiGraphics.method_51448().translate((float)x - (float)x * scale, (float)y - (float)y * scale);
            guiGraphics.method_51448().scale(scale, scale);
        }
        this.drawCenteredStringNoShadow(guiGraphics, this.method_25440(), x, y, this.getBook().getDefaultTitleColor(), 1.0f);
        guiGraphics.method_51448().popMatrix();
    }

    public void drawCenteredStringNoShadow(class_332 guiGraphics, class_2561 s, int x, int y, int color) {
        this.drawCenteredStringNoShadow(guiGraphics, s, x, y, color, 1.0f);
    }

    public void drawCenteredStringNoShadow(class_332 guiGraphics, class_2561 s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.field_22793.method_27525((class_5348)s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.field_22793);
        GuiGraphicsExt.drawString(guiGraphics, this.field_22793, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public BookParentScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.parentScreen.getBook());
            }
        }
    }

    protected void drawTooltip(class_332 guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.method_71274(this.tooltip.stream().map(class_2561::method_30937).toList(), pMouseX, pMouseY);
        }
    }

    protected void onPageChanged() {
        this.createEntryList();
    }

    protected void resetTooltip() {
        this.tooltip = null;
    }

    protected boolean shouldShowDescription() {
        return !this.category.getDescription().isEmpty();
    }

    private void createEntryList() {
        this.entryButtons.forEach(b -> {
            this.field_33816.remove(b);
            this.method_25396().remove(b);
            this.field_33815.remove(b);
        });
        this.entryButtons.clear();
        this.visibleEntries.clear();
        this.visibleEntries.addAll(this.allEntries);
        this.maxOpenPagesIndex = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxOpenPagesIndex += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.openPagesIndex;
        }
        if (this.openPagesIndex == 0) {
            if (this.shouldShowDescription()) {
                this.addEntryButtons(138, 35, 0, 11);
            } else {
                this.addEntryButtons(12, 35, 0, 11);
                this.addEntryButtons(138, 15, 11, 13);
            }
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(12, 15, start, 13);
            this.addEntryButtons(138, 15, start + 13, 13);
        }
    }

    private int getEntryCountStart() {
        if (this.openPagesIndex == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.openPagesIndex - 1);
    }

    private List<BookEntry> getEntries() {
        return this.category.getEntries().values().stream().toList();
    }

    @Override
    public void setTooltip(List<class_2561> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Book getBook() {
        return this.parentScreen.getBook();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (BookGuiManager.get().openBookEntryScreen != null) {
            return;
        }
        this.resetTooltip();
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)this.bookLeft, (float)this.bookTop);
        BookContentRenderer.renderBookBackground(guiGraphics, this.getBook().getBookContentTexture());
        if (this.openPagesIndex == 0) {
            if (!this.shouldShowDescription()) {
                this.drawTitle(guiGraphics, 74, 15);
                BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 74, 27);
            } else {
                this.drawTitle(guiGraphics, 74, 15);
                this.drawCenteredStringNoShadow(guiGraphics, (class_2561)class_2561.method_43471((String)"modonomicon.gui.category.index_list_title"), 203, 15, this.parentScreen.getBook().getDefaultTitleColor());
                BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 74, 27);
                BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 203, 27);
                BookPageRenderer.renderBookTextHolder(guiGraphics, this.category.getDescription(), this.field_22793, 12, 37, 124, 118);
            }
        }
        guiGraphics.method_51448().popMatrix();
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    @Override
    public void onDisplay() {
    }

    @Override
    public void method_25419() {
        BookGuiManager.get().closeCategoryScreen(this);
    }

    @Override
    public void loadState(CategoryVisualState state) {
        this.openPagesIndex = state.openPagesIndex;
    }

    @Override
    public void saveState(CategoryVisualState state) {
        state.openPagesIndex = this.openPagesIndex;
    }

    @Override
    public BookCategory getCategory() {
        return this.category;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 256) {
            BookGuiManager.get().closeScreenStack(this);
            return true;
        }
        if (event.comp_4795() == 257 && this.visibleEntries.size() == 1) {
            BookEntry entry = this.visibleEntries.get(0);
            BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
            return true;
        }
        return super.method_25404(event);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.allEntries = this.getEntries().stream().filter(e -> BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, e.getCategory()) && BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, (BookEntry)e)).sorted(Comparator.comparingInt(BookEntry::getSortNumber).thenComparing(a -> class_1074.method_4662((String)a.getName(), (Object[])new Object[0]))).toList();
        this.createEntryList();
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            BookEntry entry = this.visibleEntries.get(start + i);
            EntryListButton button = new EntryListButton(entry, this.bookLeft + x, this.bookTop + y + i * 11, this::handleEntryListButton);
            button.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)entry.getDescription())));
            this.method_37063((class_364)button);
            this.entryButtons.add(button);
        }
    }
}

