/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.commonmark.node.Link;
import org.commonmark.node.Node;

public class BookLinkRenderer
implements LinkRenderer {
    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {
        if (BookLink.isBookLink(link.getDestination())) {
            class_5251 currentColor = context.getCurrentStyle().method_10973();
            BookErrorManager.get().setContext("Link: {}, \n{}", link.getDestination(), BookErrorManager.get().getContextHelper());
            try {
                BookLink bookLink = BookLink.from(context.getBook(), link.getDestination());
                Book book = BookDataManager.get().getBook(bookLink.bookId);
                class_5250 goToText = class_2561.method_43471((String)book.getName());
                if (bookLink.categoryId != null) {
                    BookCategory category = book.getCategory(bookLink.categoryId);
                    goToText = class_2561.method_43471((String)category.getName());
                }
                if (bookLink.entryId != null) {
                    BookEntry entry = book.getEntry(bookLink.entryId);
                    goToText = class_2561.method_43471((String)entry.getName());
                }
                class_5250 hoverComponent = class_2561.method_43469((String)"modonomicon.gui.hover.book_link", (Object[])new Object[]{goToText});
                context.setCurrentStyle(context.getCurrentStyle().method_27703(currentColor == null ? context.getLinkColor() : currentColor).method_10958((class_2558)new class_2558.class_10607(link.getDestination())).method_10949((class_2568)new class_2568.class_10613((class_2561)hoverComponent)));
                visitChildren.accept((Node)link);
                context.setCurrentStyle(context.getCurrentStyle().method_27703(currentColor).method_10958(null).method_10949(null));
            }
            catch (Exception e) {
                if (context.getBook().allowOpenBooksWithInvalidLinks()) {
                    Modonomicon.LOG.error("Failed to parse book link. allowOpenBooksWithInvalidLinks = true, so book parsing continues. Original error:", (Throwable)e);
                    class_5250 hoverComponent = class_2561.method_43469((String)"modonomicon.gui.hover.book_link.error", (Object[])new Object[]{link.getDestination()}).method_27692(class_124.field_1061);
                    context.setCurrentStyle(context.getCurrentStyle().method_10977(class_124.field_1061).method_10949((class_2568)new class_2568.class_10613((class_2561)hoverComponent)));
                    visitChildren.accept((Node)link);
                    context.setCurrentStyle(context.getCurrentStyle().method_27703(currentColor).method_10958(null).method_10949(null));
                }
                throw e;
            }
            BookErrorManager.get().setContext(null, new Object[0]);
            return true;
        }
        return false;
    }
}

