/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.node;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookScreenWithButtons;
import com.klikli_dev.modonomicon.client.gui.book.bookmarks.BookBookmarksScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.CategoryButton;
import com.klikli_dev.modonomicon.client.gui.book.button.CategoryScrollButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ReadAllButton;
import com.klikli_dev.modonomicon.client.gui.book.button.SearchButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ShowBookmarksButton;
import com.klikli_dev.modonomicon.client.gui.book.node.BookCategoryNodeScreen;
import com.klikli_dev.modonomicon.client.gui.book.search.BookSearchScreen;
import com.klikli_dev.modonomicon.networking.BookClosedMessage;
import com.klikli_dev.modonomicon.networking.ClickReadAllButtonMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class BookParentNodeScreen
extends class_437
implements BookParentScreen,
BookScreenWithButtons {
    public static final int MAX_CATEGORY_BUTTONS = 13;
    private final Book book;
    private final List<BookCategory> categories;
    private final int frameThicknessW = 14;
    private final int frameThicknessH = 14;
    public int renderMouseXOverride = -1;
    public int renderMouseYOverride = -1;
    private BookCategoryNodeScreen currentCategoryNodeScreen;
    private boolean hasUnreadEntries;
    private boolean hasUnreadUnlockedEntries;
    private int categoryButtonRenderOffset = 0;

    public BookParentNodeScreen(Book book) {
        super((class_2561)class_2561.method_43470((String)""));
        this.field_22787 = class_310.method_1551();
        this.book = book;
        this.categories = book.getCategoriesSorted();
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    @Override
    public void onDisplay() {
        this.updateUnreadEntriesState();
    }

    protected void updateUnreadEntriesState() {
        this.hasUnreadEntries = this.book.getEntries().values().stream().anyMatch(e -> !BookUnlockStateManager.get().isReadFor((class_1657)this.field_22787.field_1724, (BookEntry)e));
        this.hasUnreadUnlockedEntries = this.book.getEntries().values().stream().anyMatch(e -> BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, (BookEntry)e) && !BookUnlockStateManager.get().isReadFor((class_1657)this.field_22787.field_1724, (BookEntry)e));
    }

    public BookCategoryNodeScreen getCurrentCategoryScreen() {
        return this.currentCategoryNodeScreen;
    }

    public void setCurrentCategoryScreen(BookCategoryNodeScreen currentCategoryNodeScreen) {
        this.currentCategoryNodeScreen = currentCategoryNodeScreen;
    }

    @Override
    public Book getBook() {
        return this.book;
    }

    @Override
    public void setTooltip(List<class_2561> tooltip) {
    }

    public class_2960 getBookOverviewTexture() {
        return this.book.getBookOverviewTexture();
    }

    public int getInnerX() {
        int n = (this.field_22789 - this.getFrameWidth()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerY() {
        int n = (this.field_22790 - this.getFrameHeight()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerWidth() {
        int n = this.getFrameWidth();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getInnerHeight() {
        int n = this.getFrameHeight();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getFrameThicknessW() {
        Objects.requireNonNull(this);
        return 14;
    }

    public int getFrameThicknessH() {
        Objects.requireNonNull(this);
        return 14;
    }

    public int getFrameWidth() {
        return this.field_22789 - 60;
    }

    public int getFrameHeight() {
        return this.field_22790 - 20;
    }

    protected void renderFrame(class_332 guiGraphics) {
        int width = this.getFrameWidth();
        int height = this.getFrameHeight();
        int x = (this.field_22789 - width) / 2;
        int y = (this.field_22790 - height) / 2;
        GuiGraphicsExt.blitWithBorder(guiGraphics, class_10799.field_56883, this.book.getFrameTexture(), x, y, 0, 0, width, height, 140, 140, 50, 50, 50, 50);
        this.renderFrameOverlay(guiGraphics, this.book.getTopFrameOverlay(), x + width / 2, y);
        this.renderFrameOverlay(guiGraphics, this.book.getBottomFrameOverlay(), x + width / 2, y + height);
        this.renderFrameOverlay(guiGraphics, this.book.getLeftFrameOverlay(), x, y + height / 2);
        this.renderFrameOverlay(guiGraphics, this.book.getRightFrameOverlay(), x + width, y + height / 2);
    }

    protected void renderFrameOverlay(class_332 guiGraphics, BookFrameOverlay overlay, int x, int y) {
        if (overlay.getFrameWidth() > 0 && overlay.getFrameHeight() > 0) {
            guiGraphics.method_25290(class_10799.field_56883, overlay.getTexture(), overlay.getFrameX(x), overlay.getFrameY(y), (float)overlay.getFrameU(), (float)overlay.getFrameV(), overlay.getFrameWidth(), overlay.getFrameHeight(), 256, 256);
        }
    }

    protected void onBookCategoryButtonClick(CategoryButton button) {
        BookGuiManager.get().openCategory(button.getCategory(), BookAddress.defaultFor(button.getCategory().getBook()));
    }

    protected void onReadAllButtonClick(ReadAllButton button) {
        if (this.hasUnreadUnlockedEntries && !class_310.method_1551().method_74187()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), false));
            this.hasUnreadUnlockedEntries = false;
        } else if (this.hasUnreadEntries && class_310.method_1551().method_74187()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), true));
            this.hasUnreadEntries = false;
        }
    }

    protected boolean canSeeReadAllButton() {
        return this.hasUnreadEntries || this.hasUnreadUnlockedEntries;
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        this.getCurrentCategoryScreen().mouseClicked(event, isDoubleClick);
        return super.method_25402(event, isDoubleClick);
    }

    public boolean method_25403(class_11909 event, double mouseX, double mouseY) {
        return this.getCurrentCategoryScreen().mouseDragged(event, mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.getCurrentCategoryScreen().zoom(scrollY);
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.renderMouseXOverride != -1 && this.renderMouseYOverride != -1) {
            pMouseX = this.renderMouseXOverride;
            pMouseY = this.renderMouseYOverride;
        }
        this.getCurrentCategoryScreen().renderBackground(guiGraphics);
        this.getCurrentCategoryScreen().render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderFrame(guiGraphics);
        this.getCurrentCategoryScreen().renderEntryTooltips(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.renderMouseXOverride = -1;
        this.renderMouseYOverride = -1;
    }

    public boolean method_25404(class_11908 event) {
        if (this.getCurrentCategoryScreen().keyPressed(event)) {
            return true;
        }
        if (event.comp_4795() == 256) {
            BookGuiManager.get().closeScreenStack(this);
            return true;
        }
        return super.method_25404(event);
    }

    @Override
    public void method_25419() {
    }

    @Override
    public void loadState(BookVisualState state) {
    }

    @Override
    public void saveState(BookVisualState state) {
    }

    private void sendBookClosedPacket(class_1268 hand) {
        Services.NETWORK.sendToServer(new BookClosedMessage(hand));
    }

    public boolean method_25430(@Nullable class_2583 pStyle) {
        return super.method_25430(pStyle);
    }

    @Override
    public void onSyncBookUnlockStatesMessage(SyncBookUnlockStatesMessage message) {
        this.method_41843();
        this.updateUnreadEntriesState();
    }

    protected void method_25426() {
        super.method_25426();
        int buttonXOffset = -11;
        int buttonYOffset = 30 + this.getBook().getCategoryButtonYOffset();
        int buttonX = (this.field_22789 - this.getFrameWidth()) / 2 - this.getFrameThicknessW() + buttonXOffset;
        int buttonY = (this.field_22790 - this.getFrameHeight()) / 2 - this.getFrameThicknessH() + buttonYOffset;
        int buttonWidth = (this.field_22789 - this.getFrameWidth()) / 2 + buttonXOffset + 6;
        int buttonHeight = 20;
        int buttonSpacing = 2;
        this.updateCategoryButtons(buttonX, buttonY, buttonWidth, buttonHeight, buttonSpacing);
        int readAllButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 - 3;
        int readAllButtonYOffset = 30 + this.getBook().getReadAllButtonYOffset();
        int readAllButtonY = (this.field_22790 - this.getFrameHeight()) / 2 + 7 + readAllButtonYOffset;
        ReadAllButton readAllButton = new ReadAllButton(this, readAllButtonX, readAllButtonY, () -> this.hasUnreadUnlockedEntries, this::canSeeReadAllButton, b -> this.onReadAllButtonClick((ReadAllButton)b));
        this.method_37063((class_364)readAllButton);
        int searchButtonXOffset = 7;
        int searchButtonYOffset = -30 + this.getBook().getSearchButtonYOffset();
        int searchButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 + searchButtonXOffset;
        int searchButtonY = this.getFrameHeight() + this.getFrameThicknessH() - 7 + searchButtonYOffset;
        int searchButtonWidth = 44;
        int scissorX = this.getFrameWidth() + this.getFrameThicknessW() * 2 + 2;
        SearchButton searchButton = new SearchButton(this, searchButtonX, searchButtonY, scissorX, searchButtonWidth, buttonHeight, b -> this.onSearchButtonClick((SearchButton)b), class_7919.method_47407((class_2561)class_2561.method_43471((String)"modonomicon.gui.open_search")));
        this.method_37063((class_364)searchButton);
        ShowBookmarksButton showBookmarksButton = new ShowBookmarksButton(this, searchButtonX, searchButtonY -= buttonHeight + 2, scissorX, searchButtonWidth, buttonHeight, b -> this.onShowBookmarksButtonClick((ShowBookmarksButton)b), class_7919.method_47407((class_2561)class_2561.method_43471((String)"modonomicon.gui.open_bookmarks")));
        this.method_37063((class_364)showBookmarksButton);
    }

    protected void updateCategoryButtons(int buttonX, int buttonY, int buttonWidth, int buttonHeight, int buttonSpacing) {
        int buttonCount = 0;
        int size = this.categories.size();
        for (int i = this.categoryButtonRenderOffset; i < size && buttonCount < 13; ++i) {
            if (!this.categories.get(i).showCategoryButton() || !BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, this.categories.get(i))) continue;
            CategoryButton button = new CategoryButton(this, this.categories.get(i), buttonX, buttonY + (buttonHeight + buttonSpacing) * buttonCount, buttonWidth, buttonHeight, b -> this.onBookCategoryButtonClick((CategoryButton)b), class_7919.method_47407((class_2561)class_2561.method_43471((String)this.categories.get(i).getName())));
            this.method_37063((class_364)button);
            ++buttonCount;
        }
        buttonX += 8;
        if (this.categoryButtonRenderOffset > 0) {
            int topScrollButtonY = (this.field_22790 - this.getFrameHeight()) / 2 - 5;
            CategoryScrollButton topScrollButton = new CategoryScrollButton(this, buttonX, topScrollButtonY, false, () -> this.categoryButtonRenderOffset > 0, b -> {
                --this.categoryButtonRenderOffset;
                this.method_41843();
            });
            this.method_37063((class_364)topScrollButton);
        }
        if (this.categories.size() > this.categoryButtonRenderOffset + 13) {
            int bottomScrollButtonY = this.getFrameHeight() + this.getFrameThicknessH() - 7 - 3;
            CategoryScrollButton bottomScrollButton = new CategoryScrollButton(this, buttonX, bottomScrollButtonY, true, () -> this.categories.size() > this.categoryButtonRenderOffset + 13, b -> {
                ++this.categoryButtonRenderOffset;
                this.method_41843();
            });
            this.method_37063((class_364)bottomScrollButton);
        }
    }

    protected void onSearchButtonClick(SearchButton button) {
        ClientServices.GUI.pushGuiLayer(new BookSearchScreen(this));
    }

    protected void onShowBookmarksButtonClick(ShowBookmarksButton button) {
        ClientServices.GUI.pushGuiLayer(new BookBookmarksScreen(this));
    }

    public boolean method_25421() {
        return false;
    }
}

