/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.search;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.BookPaginatedScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.EntryListButton;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7225;

public class BookSearchScreen
extends BookPaginatedScreen {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    protected final List<class_4185> entryButtons = new ArrayList<class_4185>();
    protected final BookParentScreen parentScreen;
    private final List<BookEntry> visibleEntries = new ArrayList<BookEntry>();
    private int openPagesIndex;
    private int maxOpenPagesIndex;
    private List<BookEntry> allEntries;
    private class_342 searchField;
    private BookTextHolder infoText;
    private List<class_2561> tooltip;

    public BookSearchScreen(BookParentScreen parentScreen) {
        super((class_2561)class_2561.method_43471((String)"modonomicon.gui.search.screen.title"));
        this.parentScreen = parentScreen;
        this.infoText = new BookTextHolder("modonomicon.gui.search.info");
    }

    public void handleButtonEntry(class_4185 button) {
        BookEntry entry = ((EntryListButton)button).getEntry();
        this.method_25419();
        BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.infoText.hasComponent()) {
            this.infoText = new RenderedBookTextHolder(this.infoText, textRenderer.render(this.infoText.getString()));
        }
    }

    public void drawCenteredStringNoShadow(class_332 guiGraphics, class_2561 s, int x, int y, int color) {
        this.drawCenteredStringNoShadow(guiGraphics, s, x, y, color, 1.0f);
    }

    public void drawCenteredStringNoShadow(class_332 guiGraphics, class_2561 s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.field_22793.method_27525((class_5348)s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.field_22793);
        GuiGraphicsExt.drawString(guiGraphics, this.field_22793, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public BookParentScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public boolean canSeeArrowButton(boolean left) {
        return left ? this.openPagesIndex > 0 : this.openPagesIndex + 1 < this.maxOpenPagesIndex;
    }

    @Override
    protected void flipPage(boolean left, boolean playSound) {
        if (this.canSeeArrowButton(left)) {
            this.openPagesIndex = left ? --this.openPagesIndex : ++this.openPagesIndex;
            this.onPageChanged();
            if (playSound) {
                BookContentRenderer.playTurnPageSound(this.parentScreen.getBook());
            }
        }
    }

    protected void drawTooltip(class_332 guiGraphics, int pMouseX, int pMouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            guiGraphics.method_71274(this.tooltip.stream().map(class_2561::method_30937).toList(), pMouseX, pMouseY);
        }
    }

    protected void onPageChanged() {
        this.createEntryList();
    }

    protected void resetTooltip() {
        this.tooltip = null;
    }

    private void createSearchBar() {
        this.searchField = new class_342(this.field_22793, 160, 170, 90, 12, (class_2561)class_2561.method_43470((String)""));
        this.searchField.method_1880(32);
        this.searchField.method_1856(false);
        this.searchField.method_25365(true);
    }

    private void createEntryList() {
        this.entryButtons.forEach(b -> {
            this.field_33816.remove(b);
            this.method_25396().remove(b);
            this.field_33815.remove(b);
        });
        this.entryButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.method_1882().toLowerCase();
        this.allEntries.stream().filter(e -> e.matchesQuery(query, (class_1937)this.field_22787.field_1687)).forEach(this.visibleEntries::add);
        this.maxOpenPagesIndex = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxOpenPagesIndex += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.openPagesIndex;
        }
        if (this.openPagesIndex == 0) {
            this.addEntryButtons(138, 35, 0, 11);
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(12, 15, start, 13);
            this.addEntryButtons(138, 15, start + 13, 13);
        }
    }

    private int getEntryCountStart() {
        if (this.openPagesIndex == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.openPagesIndex - 1);
    }

    private List<BookEntry> getEntries() {
        return this.parentScreen.getBook().getEntries().values().stream().toList();
    }

    @Override
    public void setTooltip(List<class_2561> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Book getBook() {
        return this.parentScreen.getBook();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.resetTooltip();
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)this.bookLeft, (float)this.bookTop);
        BookContentRenderer.renderBookBackground(guiGraphics, this.getBook().getBookContentTexture());
        if (this.openPagesIndex == 0) {
            this.drawCenteredStringNoShadow(guiGraphics, this.method_25440(), 74, 15, this.parentScreen.getBook().getDefaultTitleColor());
            this.drawCenteredStringNoShadow(guiGraphics, (class_2561)class_2561.method_43471((String)"modonomicon.gui.search.entry_list_title"), 203, 15, this.parentScreen.getBook().getDefaultTitleColor());
            BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 74, 27);
            BookContentRenderer.drawTitleSeparator(guiGraphics, this.parentScreen.getBook(), 203, 27);
            BookPageRenderer.renderBookTextHolder(guiGraphics, this.infoText, this.field_22793, 12, 37, 124, 118);
        }
        if (!this.searchField.method_1882().isEmpty()) {
            BookContentRenderer.drawFromContentTexture(class_10799.field_56883, guiGraphics, this.parentScreen.getBook(), this.searchField.method_46426() - 8, this.searchField.method_46427(), 140, 183, 99, 14);
            class_5250 searchComponent = class_2561.method_43470((String)this.searchField.method_1882());
            guiGraphics.method_51439(this.field_22793, (class_2561)searchComponent, this.searchField.method_46426() + 7, this.searchField.method_46427() + 1, 0, false);
        }
        if (this.visibleEntries.isEmpty()) {
            if (!this.searchField.method_1882().isEmpty()) {
                this.drawCenteredStringNoShadow(guiGraphics, (class_2561)class_2561.method_43471((String)"modonomicon.gui.search.no_results"), 203, 80, 0x333333);
                guiGraphics.method_51448().scale(2.0f, 2.0f);
                this.drawCenteredStringNoShadow(guiGraphics, (class_2561)class_2561.method_43471((String)"modonomicon.gui.search.sad"), 101, 47, 0x999999);
                guiGraphics.method_51448().scale(0.5f, 0.5f);
            } else {
                this.drawCenteredStringNoShadow(guiGraphics, (class_2561)class_2561.method_43471((String)"modonomicon.gui.search.no_results"), 203, 80, 0x333333);
            }
        }
        guiGraphics.method_51448().popMatrix();
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.drawTooltip(guiGraphics, pMouseX, pMouseY);
    }

    public void method_25419() {
        ClientServices.GUI.popGuiLayer();
    }

    @Override
    public boolean method_25404(class_11908 event) {
        String currQuery = this.searchField.method_1882();
        if (event.comp_4795() == 257) {
            if (this.visibleEntries.size() == 1) {
                BookEntry entry = this.visibleEntries.get(0);
                BookGuiManager.get().openEntry(entry.getBook().getId(), entry.getId(), 0);
                return true;
            }
        } else if (this.searchField.method_25404(event)) {
            if (!this.searchField.method_1882().equals(currQuery)) {
                this.createEntryList();
            }
            return true;
        }
        return super.method_25404(event);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        BookTextRenderer textRenderer = new BookTextRenderer(this.getBook(), (class_7225.class_7874)this.field_22787.field_1687.method_30349());
        this.prerenderMarkdown(textRenderer);
        this.allEntries = this.getEntries().stream().filter(e -> BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, e.getCategory()) && BookUnlockStateManager.get().isUnlockedFor((class_1657)this.field_22787.field_1724, (BookEntry)e)).sorted(Comparator.comparing(a -> class_1074.method_4662((String)a.getName(), (Object[])new Object[0]))).toList();
        this.createSearchBar();
        this.createEntryList();
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (super.method_25402(event, isDoubleClick)) {
            return true;
        }
        class_11909 localEvent = new class_11909(event.comp_4798() - (double)this.bookLeft, event.comp_4799() - (double)this.bookTop, event.comp_4800());
        return this.searchField.method_25402(localEvent, isDoubleClick);
    }

    public boolean method_25400(class_11905 event) {
        String currQuery = this.searchField.method_1882();
        if (this.searchField.method_25400(event)) {
            if (!this.searchField.method_1882().equals(currQuery)) {
                this.createEntryList();
            }
            return true;
        }
        return super.method_25400(event);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            EntryListButton button = new EntryListButton(this.visibleEntries.get(start + i), this.bookLeft + x, this.bookTop + y + i * 11, this::handleButtonEntry);
            this.method_37063((class_364)button);
            this.entryButtons.add(button);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

