/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.MultiblockPreviewData;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.GhostVertexConsumer;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11658;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_898;
import net.minecraft.class_9799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockPreviewRenderer {
    private static final Map<class_2338, class_2586> blockEntityCache = new Object2ObjectOpenHashMap();
    private static final Set<class_2586> erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
    public static boolean hasMultiblock;
    private static Multiblock multiblock;
    private static class_2561 name;
    private static class_2338 pos;
    private static boolean isAnchored;
    private static class_2470 facingRotation;
    private static Function<class_2338, class_2338> offsetApplier;
    private static int blocks;
    private static int blocksDone;
    private static int airFilled;
    private static int timeComplete;
    private static class_2680 lookingState;
    private static class_2338 lookingPos;
    private static class_4597.class_4598 buffers;

    public static void setMultiblock(Multiblock multiblock, class_2561 name, boolean flip) {
        MultiblockPreviewRenderer.setMultiblock(multiblock, name, flip, pos -> pos);
    }

    public static void setMultiblock(Multiblock multiblock, class_2561 name, boolean flip, Function<class_2338, class_2338> offsetApplier) {
        if (flip && hasMultiblock && MultiblockPreviewRenderer.multiblock == multiblock) {
            hasMultiblock = false;
        } else {
            MultiblockPreviewRenderer.multiblock = multiblock;
            blockEntityCache.clear();
            erroredBlockEntities.clear();
            MultiblockPreviewRenderer.name = name;
            MultiblockPreviewRenderer.offsetApplier = offsetApplier;
            pos = null;
            hasMultiblock = multiblock != null;
            isAnchored = false;
        }
    }

    public static void onRenderHUD(class_332 guiGraphics, float partialTicks) {
        if (hasMultiblock) {
            int fullAnimTime;
            int waitTime = 40;
            int fadeOutSpeed = 4;
            float animTime = (float)timeComplete + (timeComplete == 0 ? 0.0f : partialTicks);
            if (animTime > (float)(fullAnimTime = waitTime + 10)) {
                hasMultiblock = false;
                return;
            }
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate(0.0f, -Math.max(0.0f, animTime - (float)waitTime) * (float)fadeOutSpeed);
            class_310 mc = class_310.method_1551();
            int x = mc.method_22683().method_4486() / 2;
            int y = 12;
            GuiGraphicsExt.drawString(guiGraphics, mc.field_1772, name, (float)x - (float)mc.field_1772.method_27525((class_5348)name) / 2.0f, (float)y, -1, false);
            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;
            if (timeComplete > 0) {
                String s = class_1074.method_4662((String)"modonomicon.multiblock.complete", (Object[])new Object[0]);
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate(0.0f, Math.min((float)(height + 5), animTime));
                guiGraphics.method_51433(mc.field_1772, s, (int)((float)x - (float)mc.field_1772.method_1727(s) / 2.0f), top + height - 10, 65280, false);
                guiGraphics.method_51448().popMatrix();
            }
            guiGraphics.method_25294(left - 1, top - 1, left + width + 1, top + height + 1, -16777216);
            guiGraphics.method_25296(left, top, left + width, top + height, -10066330, -10066330);
            float fract = (float)blocksDone / (float)Math.max(1, blocks);
            int progressWidth = (int)((float)width * fract);
            int color = class_3532.method_15369((float)(fract / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();
            guiGraphics.method_25296(left, top, left + progressWidth, top + height, color, color2);
            if (!isAnchored) {
                String s = class_1074.method_4662((String)"modonomicon.multiblock.not_anchored", (Object[])new Object[0]);
                guiGraphics.method_51433(mc.field_1772, s, (int)((float)x - (float)mc.field_1772.method_1727(s) / 2.0f), top + height + 8, 0xFFFFFF, false);
            } else {
                if (lookingState != null) {
                    try {
                        class_1799 stack = lookingState.method_65171((class_4538)mc.field_1687, lookingPos, true);
                        if (!stack.method_7960()) {
                            guiGraphics.method_51439(mc.field_1772, stack.method_7964(), left + 20, top + height + 8, 0xFFFFFF, false);
                            guiGraphics.method_51427(stack, left, top + height + 2);
                        }
                    }
                    catch (Exception stack) {
                        // empty catch block
                    }
                }
                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    float mult = 1.0f;
                    Object progress = blocksDone + "/" + blocks;
                    if (blocksDone == blocks && airFilled > 0) {
                        progress = class_1074.method_4662((String)"modonomicon.multiblock.remove_blocks", (Object[])new Object[0]);
                        color = 14306879;
                        mult *= 2.0f;
                        posx -= width / 2;
                        posy += 2;
                    }
                    guiGraphics.method_51433(mc.field_1772, (String)progress, (int)((float)posx - (float)mc.field_1772.method_1727((String)progress) / mult), posy, color, true);
                }
            }
            guiGraphics.method_51448().popMatrix();
        }
    }

    public static void onRenderLevelLastEvent(class_11658 levelRenderState, class_4587 poseStack) {
        if (hasMultiblock && multiblock != null) {
            MultiblockPreviewRenderer.renderMultiblock(levelRenderState, poseStack);
        }
    }

    public static void anchorTo(class_2338 target, class_2470 rot) {
        pos = target;
        facingRotation = rot;
        isAnchored = true;
    }

    public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (hasMultiblock && !isAnchored && player == class_310.method_1551().field_1724) {
            MultiblockPreviewRenderer.anchorTo(hit.method_17777(), MultiblockPreviewRenderer.getRotation((class_1297)player));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static void onClientTick(class_310 mc) {
        if (class_310.method_1551().field_1687 == null) {
            hasMultiblock = false;
        } else if (isAnchored && blocks == blocksDone && airFilled == 0) {
            if (++timeComplete == 14) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)1.0f));
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void extractRenderState(class_11658 levelRenderState) {
        if (!hasMultiblock || multiblock == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        if (!isAnchored) {
            facingRotation = MultiblockPreviewRenderer.getRotation((class_1297)mc.field_1724);
            if (mc.field_1765 instanceof class_3965) {
                pos = ((class_3965)mc.field_1765).method_17777();
            }
        } else if (pos.method_19770((class_2374)mc.field_1724.method_73189()) > 4096.0) {
            return;
        }
        if (pos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = class_2470.field_11467;
        }
        multiblock.setLevel((class_1937)level);
        class_2338 startPos = MultiblockPreviewRenderer.getStartPos();
        Pair<class_2338, Collection<Multiblock.SimulateResult>> sim = multiblock.simulate((class_1937)level, startPos, MultiblockPreviewRenderer.getFacingRotation(), true, false);
        for (Multiblock.SimulateResult r : (Collection)sim.getSecond()) {
            try {
                class_2680 displayedState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).method_26186(facingRotation);
                class_2248 class_22482 = displayedState.method_26204();
                if (!(class_22482 instanceof class_2343)) continue;
                class_2343 eb = (class_2343)class_22482;
                class_2338 cacheKey = r.getWorldPosition().method_10059((class_2382)startPos).method_10062();
                class_2586 be = blockEntityCache.compute(cacheKey, (p, cachedBe) -> {
                    if (cachedBe != null && !cachedBe.method_11017().method_20526(displayedState)) {
                        return eb.method_10123(p, displayedState);
                    }
                    return cachedBe != null ? cachedBe : eb.method_10123(p, displayedState);
                });
                if (be == null || erroredBlockEntities.contains(be)) continue;
                be.method_31662((class_1937)mc.field_1687);
                be.method_31664(displayedState);
                class_11954 renderState = class_310.method_1551().method_31975().method_74348(be, ClientTicks.partialTicks, null);
                if (renderState == null) continue;
                levelRenderState.field_62646.add(renderState);
            }
            catch (Exception e) {
                Modonomicon.LOG.error("Error extracting block entity render state", (Throwable)e);
            }
        }
    }

    public static void renderMultiblock(class_11658 levelRenderState, class_4587 ms) {
        if (!hasMultiblock || multiblock == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        if (!isAnchored) {
            if (mc.field_1765 instanceof class_3965) {
                pos = ((class_3965)mc.field_1765).method_17777();
            }
        } else if (pos.method_19770((class_2374)mc.field_1724.method_73189()) > 4096.0) {
            return;
        }
        if (pos == null) {
            return;
        }
        class_898 erd = mc.method_1561();
        double renderPosX = erd.field_4686.method_19326().method_10216();
        double renderPosY = erd.field_4686.method_19326().method_10214();
        double renderPosZ = erd.field_4686.method_19326().method_10215();
        ms.method_22903();
        ms.method_22904(-renderPosX, -renderPosY, -renderPosZ);
        if (buffers == null) {
            buffers = MultiblockPreviewRenderer.initBuffers(mc.method_22940().method_23000());
        }
        class_2338 checkPos = null;
        class_239 class_2392 = mc.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockRes = (class_3965)class_2392;
            checkPos = blockRes.method_17777().method_10093(blockRes.method_17780());
        }
        class_2338 startPos = MultiblockPreviewRenderer.getStartPos();
        Pair<class_2338, Collection<Multiblock.SimulateResult>> sim = multiblock.simulate((class_1937)level, startPos, MultiblockPreviewRenderer.getFacingRotation(), true, false);
        for (Multiblock.SimulateResult r : (Collection)sim.getSecond()) {
            boolean air;
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            if (r.getStateMatcher().equals(Matchers.ANY) || r.getStateMatcher().getType() == DisplayOnlyMatcher.TYPE) continue;
            boolean bl = air = !r.getStateMatcher().countsTowardsTotalBlocks();
            if (r.test((class_1937)level, facingRotation)) continue;
            class_2680 displayedState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).method_26186(facingRotation);
            MultiblockPreviewRenderer.renderBlock((class_1937)level, displayedState, r.getWorldPosition(), multiblock, air, alpha, ms);
        }
        for (class_11954 blockEntityRenderState : levelRenderState.field_62646) {
            ms.method_22903();
            ms.method_46416((float)blockEntityRenderState.field_62673.method_10263(), (float)blockEntityRenderState.field_62673.method_10264(), (float)blockEntityRenderState.field_62673.method_10260());
            class_310.method_1551().method_31975().method_3555(blockEntityRenderState, ms, (class_11659)class_310.method_1551().field_1773.method_72910(), levelRenderState.field_63082);
            ms.method_22909();
        }
        buffers.method_22993();
        ms.method_22909();
    }

    public static void renderBlock(class_1937 world, class_2680 state, class_2338 pos, Multiblock multiblock, boolean isAir, float alpha, class_4587 ms) {
        if (pos != null) {
            ms.method_22903();
            ms.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            if (state.method_26204() == class_2246.field_10124) {
                float scale = 0.3f;
                float off = (1.0f - scale) / 2.0f;
                ms.method_46416(off, off, off);
                ms.method_22905(scale, scale, scale);
                state = class_2246.field_10058.method_9564();
            }
            ClientServices.MULTIBLOCK.renderBlock(state, pos, multiblock, ms, (class_4597)buffers, world.method_8409());
            ms.method_22909();
        }
    }

    @Nullable
    public static MultiblockPreviewData getMultiblockPreviewData() {
        if (!hasMultiblock) {
            return null;
        }
        return new MultiblockPreviewData(multiblock, pos, facingRotation, isAnchored);
    }

    public static Multiblock getMultiblock() {
        return multiblock;
    }

    public static boolean isAnchored() {
        return isAnchored;
    }

    public static class_2470 getFacingRotation() {
        return multiblock.isSymmetrical() ? class_2470.field_11467 : facingRotation;
    }

    public static class_2338 getStartPos() {
        return offsetApplier.apply(pos);
    }

    private static class_2470 getRotation(class_1297 entity) {
        return AbstractMultiblock.rotationFromFacing(entity.method_5735());
    }

    private static class_4597.class_4598 initBuffers(class_4597.class_4598 original) {
        class_9799 fallback = original.field_52156;
        SequencedMap layerBuffers = original.field_20953;
        return new GhostBuffers(fallback, layerBuffers);
    }

    static {
        buffers = null;
    }

    private static class GhostBuffers
    extends class_4597.class_4598 {
        protected GhostBuffers(class_9799 fallback, SequencedMap<class_1921, class_9799> layerBuffers) {
            super(fallback, layerBuffers);
        }

        @NotNull
        public class_4588 method_73477(@NotNull class_1921 type) {
            return GhostVertexConsumer.remap(super.method_73477(type));
        }
    }
}

