/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.page.BookEntityPage;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.util.EntityUtil;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class BookEntityPageRenderer
extends BookPageRenderer<BookEntityPage>
implements PageWithTextRenderer {
    private class_1297 entity;
    private boolean errored;
    private float renderScale;
    private float renderOffset;

    public BookEntityPageRenderer(BookEntityPage page) {
        super(page);
    }

    public static void renderEntity(class_332 guiGraphics, class_1297 entity, class_1937 world, float x, float y, float rotation, float renderScale, float offset) {
    }

    private void loadEntity(class_1937 world) {
        if (!(this.errored || this.entity != null && this.entity.method_5805())) {
            try {
                Function<class_1937, class_1297> entityLoader = EntityUtil.getEntityLoader(((BookEntityPage)this.page).getEntityId());
                this.entity = entityLoader.apply(world);
                float width = this.entity.method_17681();
                float height = this.entity.method_17682();
                float entitySize = Math.max(1.0f, Math.max(width, height));
                this.renderScale = 100.0f / entitySize * 0.8f * ((BookEntityPage)this.getPage()).getScale();
                this.renderOffset = Math.max(height, entitySize) * 0.5f + ((BookEntityPage)this.getPage()).getOffset();
            }
            catch (Exception e) {
                this.errored = true;
                Modonomicon.LOG.error("Failed to load entity", (Throwable)e);
            }
        }
    }

    @Override
    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.loadEntity((class_1937)class_310.method_1551().field_1687);
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float ticks) {
        class_2583 style;
        if (!((BookEntityPage)this.page).getEntityName().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookEntityPage)this.page).getEntityName(), false, 62, 0);
        }
        int textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, ((BookEntityPage)this.getPage()).getText(), 0, textY, 124, 155 - textY);
        int x = 9;
        int y = 7;
        BookContentRenderer.drawFromContentTexture(class_10799.field_56883, guiGraphics, ((BookEntityPage)this.getPage()).getBook(), x, y, 405, 149, 106, 106);
        if (this.errored) {
            guiGraphics.method_51439(this.font, (class_2561)class_2561.method_43471((String)"modonomicon.gui.page.entity.loading_error"), 58, 60, 0xFF0000, true);
        }
        if (this.entity != null) {
            float rotation = ((BookEntityPage)this.page).doesRotate() ? ClientTicks.total : ((BookEntityPage)this.page).getDefaultRotation();
            BookEntityPageRenderer.renderEntity(guiGraphics, this.entity, (class_1937)class_310.method_1551().field_1687, 58.0f, 60.0f, rotation, this.renderScale, this.renderOffset);
        }
        if ((style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public class_2583 getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            class_2583 titleStyle;
            if (!((BookEntityPage)this.page).getEntityName().isEmpty() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookEntityPage)this.page).getEntityName(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            int x = this.parentScreen.getBook().getBookTextOffsetX();
            int y = this.getTextY() + this.parentScreen.getBook().getBookTextOffsetY();
            int width = 124 + this.parentScreen.getBook().getBookTextOffsetWidth() - x;
            int height = 155 + this.parentScreen.getBook().getBookTextOffsetHeight() - y;
            class_2583 textStyle = this.getClickedComponentStyleAtForTextHolder(((BookEntityPage)this.page).getText(), x, y, width, height, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    @Override
    public int getTextY() {
        return 115;
    }
}

