/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.page.BookBlastingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookCampfireCookingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookCraftingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookEmptyPage;
import com.klikli_dev.modonomicon.book.page.BookEntityPage;
import com.klikli_dev.modonomicon.book.page.BookImagePage;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.book.page.BookProcessingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmeltingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmithingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmokingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSpotlightPage;
import com.klikli_dev.modonomicon.book.page.BookStonecuttingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.client.render.page.BookCraftingRecipePageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookEmptyPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookEntityPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookImagePageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookMultiblockPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookProcessingRecipePageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookSmithingRecipePageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookSpotlightPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookTextPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererFactory;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3975;

public class PageRendererRegistry {
    static final Set<class_1792> ITEMS_NOT_TO_RENDER = ObjectSets.synchronize((ObjectSet)new ObjectOpenHashSet());
    static final Set<class_3611> FLUIDS_NOT_TO_RENDER = ObjectSets.synchronize((ObjectSet)new ObjectOpenHashSet());
    private static final Map<class_2960, PageRendererFactory> pageRenderers = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());

    public static void registerPageRenderers() {
        PageRendererRegistry.registerDefaultPageRenderers();
    }

    private static void registerDefaultPageRenderers() {
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.TEXT, p -> new BookTextPageRenderer((BookTextPage)p));
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.MULTIBLOCK, p -> new BookMultiblockPageRenderer((BookMultiblockPage)p));
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.CRAFTING_RECIPE, p -> new BookCraftingRecipePageRenderer((BookCraftingRecipePage)p));
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.SMELTING_RECIPE, p -> new BookProcessingRecipePageRenderer<class_3861>((BookProcessingRecipePage)((BookSmeltingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.SMOKING_RECIPE, p -> new BookProcessingRecipePageRenderer<class_3862>((BookProcessingRecipePage)((BookSmokingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.CAMPFIRE_COOKING_RECIPE, p -> new BookProcessingRecipePageRenderer<class_3920>((BookProcessingRecipePage)((BookCampfireCookingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.BLASTING_RECIPE, p -> new BookProcessingRecipePageRenderer<class_3859>((BookProcessingRecipePage)((BookBlastingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.STONECUTTING_RECIPE, p -> new BookProcessingRecipePageRenderer<class_3975>((BookProcessingRecipePage)((BookStonecuttingRecipePage)p)){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.SMITHING_RECIPE, p -> new BookSmithingRecipePageRenderer((BookSmithingRecipePage)p){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.SPOTLIGHT, p -> new BookSpotlightPageRenderer((BookSpotlightPage)p){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.EMPTY, p -> new BookEmptyPageRenderer((BookEmptyPage)p){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.ENTITY, p -> new BookEntityPageRenderer((BookEntityPage)p){});
        PageRendererRegistry.registerPageRenderer(ModonomiconConstants.Data.Page.IMAGE, p -> new BookImagePageRenderer((BookImagePage)p){});
    }

    public static void registerPageRenderer(class_2960 id, PageRendererFactory factory) {
        pageRenderers.put(id, factory);
    }

    public static PageRendererFactory getPageRenderer(class_2960 id) {
        PageRendererFactory renderer = pageRenderers.get(id);
        if (renderer == null) {
            throw new IllegalArgumentException("No page renderer registered for page type " + String.valueOf(id));
        }
        return renderer;
    }

    public static void registerItemStackNotToRender(class_1799 stack) {
        ITEMS_NOT_TO_RENDER.add(stack.method_7909());
    }

    public static void registerFluidStackNotToRender(FluidHolder stack) {
        FLUIDS_NOT_TO_RENDER.add((class_3611)stack.getFluid().comp_349());
    }

    public static boolean isRenderable(class_1799 stack) {
        return !ITEMS_NOT_TO_RENDER.contains(stack.method_7909());
    }

    public static boolean isRenderable(FluidHolder stack) {
        return !FLUIDS_NOT_TO_RENDER.contains(stack.getFluid());
    }

    public static List<class_1799> filterRenderableItemStacks(Collection<class_1799> stacks) {
        return stacks.stream().filter(stack -> !ITEMS_NOT_TO_RENDER.contains(stack.method_7909())).toList();
    }

    public static List<FluidHolder> filterRenderableFluidStacks(Collection<FluidHolder> stacks) {
        return stacks.stream().filter(stack -> !FLUIDS_NOT_TO_RENDER.contains(stack.getFluid())).toList();
    }
}

