/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.config;

import com.klikli_dev.modonomicon.Modonomicon;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ClientConfig {
    public static PropertyMirror<Boolean> enableSmoothZoom = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> storeLastOpenPageWhenClosingEntry = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<List<String>> fontFallbackLocales = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));
    private static final ConfigTree CONFIG = ConfigTree.builder().fork("qol").withComment("Quality of Life Settings").beginValue("enableSmoothZoom", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Enable smooth zoom in book categories").finishValue(arg_0 -> enableSmoothZoom.mirror(arg_0)).beginValue("storeLastOpenPageWhenClosingEntry", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Enable keeping the last open page stored when closing an entry. Regardless of this setting it will be stored when closing the entire book with Esc.").finishValue(arg_0 -> storeLastOpenPageWhenClosingEntry.mirror(arg_0)).beginValue("fontFallbackLocales", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), List.of("zh_cn", "ja_jp", "ko_kr")).withComment("If your locale is not supported by the default Modonomicon font, indicated by the book just rendering blocky shapes instead of characters, add your locale to this list to fall back to the builtin Minecraft font.").finishValue(arg_0 -> fontFallbackLocales.mirror(arg_0)).finishBranch().build();

    public static void init() {
        Closeable s2;
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path path = FabricLoader.getInstance().getConfigDir().resolve("modonomicon.json5");
        try {
            s2 = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));
            try {
                FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s2, (ValueSerializer)serializer);
            }
            finally {
                ((FilterOutputStream)s2).close();
            }
        }
        catch (IOException s2) {
            // empty catch block
        }
        try {
            s2 = new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ, StandardOpenOption.CREATE));
            try {
                FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s2, (ValueSerializer)serializer);
            }
            finally {
                ((BufferedInputStream)s2).close();
            }
        }
        catch (ValueDeserializationException | IOException e) {
            Modonomicon.LOG.error("Error loading config", e);
        }
    }
}

