/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.entries.CategoryLinkBookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.BookDynamicTextMacroLoader;
import com.klikli_dev.modonomicon.data.LegacySimpleJsonResourceReloadListener;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.networking.Message;
import com.klikli_dev.modonomicon.networking.SyncBookDataMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7225;
import net.minecraft.class_8779;

public class BookDataManager
extends LegacySimpleJsonResourceReloadListener {
    public static final String FOLDER = "modonomicon/books";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final BookDataManager instance = new BookDataManager();
    private final Map<class_2960, Book> books = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private boolean loaded;
    private boolean booksBuilt;
    private class_7225.class_7874 registries;

    private BookDataManager() {
        super(GSON, FOLDER);
    }

    public static BookDataManager get() {
        return instance;
    }

    public void registries(class_7225.class_7874 registries) {
        this.registries = registries;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Map<class_2960, Book> getBooks() {
        return this.books;
    }

    public Book getBook(class_2960 id) {
        return this.books.get(id);
    }

    public Message getSyncMessage() {
        return new SyncBookDataMessage(this.books);
    }

    public boolean areBooksBuilt() {
        return this.booksBuilt;
    }

    public void onDatapackSyncPacket(SyncBookDataMessage message) {
        this.preLoad();
        this.books.putAll(message.books);
        this.onLoadingComplete();
    }

    public void onDatapackSync(class_3222 player) {
        this.tryBuildBooks((class_1937)player.method_51469());
        if (player.field_13987.field_45013.method_10756()) {
            return;
        }
        Message syncMessage = this.getSyncMessage();
        Services.NETWORK.sendToSplit(player, syncMessage);
    }

    public void onRecipesUpdated(class_1937 level) {
        Client.get().resetUseFallbackFont();
        this.tryBuildBooks(level);
        this.prerenderMarkdown((class_7225.class_7874)level.method_30349());
    }

    public void preLoad() {
        this.booksBuilt = false;
        this.loaded = false;
        this.books.clear();
        BookErrorManager.get().reset();
    }

    public void buildBooks(class_1937 level) {
        for (Book book : this.books.values()) {
            BookErrorManager.get().getContextHelper().reset();
            BookErrorManager.get().setCurrentBookId(book.getId());
            try {
                book.build(level);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to build book '" + String.valueOf(book.getId()) + "'", e);
            }
            BookErrorManager.get().setCurrentBookId(null);
        }
    }

    public void prerenderMarkdown(class_7225.class_7874 provider) {
        Modonomicon.LOG.info("Pre-rendering markdown ...");
        for (Book book : this.books.values()) {
            BookErrorManager.get().getContextHelper().reset();
            BookErrorManager.get().setCurrentBookId(book.getId());
            BookTextRenderer textRenderer = new BookTextRenderer(book, provider);
            if (!BookErrorManager.get().hasErrors(book.getId())) {
                try {
                    book.prerenderMarkdown(textRenderer);
                }
                catch (Exception e) {
                    BookErrorManager.get().error("Failed to render markdown for book '" + String.valueOf(book.getId()) + "'", e);
                }
            } else {
                BookErrorManager.get().error("Cannot render markdown for book '" + String.valueOf(book.getId()) + " because of errors during book build'");
            }
            BookErrorManager.get().setCurrentBookId(null);
        }
        Modonomicon.LOG.info("Finished pre-rendering markdown.");
    }

    public boolean tryBuildBooks(class_1937 level) {
        if (this.booksBuilt) {
            return false;
        }
        if (!level.method_8608()) {
            this.resolveMacros();
        }
        Modonomicon.LOG.info("Building books ...");
        this.buildBooks(level);
        this.booksBuilt = true;
        Modonomicon.LOG.info("Books built.");
        return true;
    }

    public void resolveMacros() {
        this.getBooks().forEach((id, book) -> {
            Collection<BookDynamicTextMacroLoader> macroLoaders = LoaderRegistry.getDynamicTextMacroLoaders(id);
            macroLoaders.forEach(loader -> loader.load().forEach(book::addMacro));
        });
    }

    protected void onLoadingComplete() {
        this.loaded = true;
    }

    private Book loadBook(class_2960 key, JsonObject value, class_7225.class_7874 provider) {
        return Book.fromJson(key, value, provider);
    }

    private BookCategory loadCategory(class_2960 key, JsonObject value, class_7225.class_7874 provider) {
        return BookCategory.fromJson(key, value, provider);
    }

    private BookEntry loadEntry(class_2960 id, JsonObject value, boolean autoAddReadConditions, class_7225.class_7874 provider) {
        if (value.has("type")) {
            class_2960 typeId = class_2960.method_12829((String)value.get("type").getAsString());
            return LoaderRegistry.getEntryJsonLoader(typeId).fromJson(id, value, autoAddReadConditions, provider);
        }
        if (value.has("category_to_open")) {
            return CategoryLinkBookEntry.fromJson(id, value, autoAddReadConditions, provider);
        }
        return BookContentEntry.fromJson(id, value, autoAddReadConditions, provider);
    }

    private BookCommand loadCommand(class_2960 key, JsonObject value) {
        return BookCommand.fromJson(key, value);
    }

    private boolean testConditionOnLoad(class_2960 key, JsonObject bookObject, class_7225.class_7874 provider) {
        if (!bookObject.has("condition")) {
            return true;
        }
        return BookCondition.fromJson(key, bookObject.getAsJsonObject("condition"), provider).testOnLoad();
    }

    private void categorizeContent(Map<class_2960, JsonElement> content, HashMap<class_2960, JsonObject> bookJsons, HashMap<class_2960, JsonObject> categoryJsons, HashMap<class_2960, JsonObject> entryJsons, HashMap<class_2960, JsonObject> commandJsons) {
        block12: for (Map.Entry<class_2960, JsonElement> entry : content.entrySet()) {
            String[] pathParts = entry.getKey().method_12832().split("/");
            class_2960 bookId = class_2960.method_60655((String)entry.getKey().method_12836(), (String)pathParts[0]);
            switch (pathParts[1]) {
                case "book": {
                    bookJsons.put(entry.getKey(), entry.getValue().getAsJsonObject());
                    continue block12;
                }
                case "entries": {
                    entryJsons.put(entry.getKey(), entry.getValue().getAsJsonObject());
                    continue block12;
                }
                case "categories": {
                    categoryJsons.put(entry.getKey(), entry.getValue().getAsJsonObject());
                    continue block12;
                }
                case "commands": {
                    commandJsons.put(entry.getKey(), entry.getValue().getAsJsonObject());
                    continue block12;
                }
            }
            Modonomicon.LOG.warn("Found unknown content for book '{}': '{}'. Should be one of: [File: book.json, Directory: entries/, Directory: categories/, Directory: commands/]", (Object)bookId, (Object)entry.getKey());
            BookErrorManager.get().error(bookId, "Found unknown content for book '" + String.valueOf(bookId) + "': '" + String.valueOf(entry.getKey()) + "'. Should be one of: [File: book.json, Directory: entries/, Directory: categories/, Directory: commands/]");
        }
    }

    protected void apply(Map<class_2960, JsonElement> content, class_3300 pResourceManager, class_3695 pProfiler) {
        Book book;
        class_2960 bookId;
        String[] pathParts;
        this.preLoad();
        HashMap<class_2960, JsonObject> bookJsons = new HashMap<class_2960, JsonObject>();
        HashMap<class_2960, JsonObject> categoryJsons = new HashMap<class_2960, JsonObject>();
        HashMap<class_2960, JsonObject> entryJsons = new HashMap<class_2960, JsonObject>();
        HashMap<class_2960, JsonObject> commandJsons = new HashMap<class_2960, JsonObject>();
        this.categorizeContent(content, bookJsons, categoryJsons, entryJsons, commandJsons);
        for (Map.Entry<class_2960, JsonObject> entry : bookJsons.entrySet()) {
            try {
                pathParts = entry.getKey().method_12832().split("/");
                bookId = class_2960.method_60655((String)entry.getKey().method_12836(), (String)pathParts[0]);
                BookErrorManager.get().setCurrentBookId(bookId);
                BookErrorManager.get().setContext("Loading Book JSON", new Object[0]);
                Book book2 = this.loadBook(bookId, entry.getValue(), this.registries);
                this.books.put(book2.getId(), book2);
                BookErrorManager.get().reset();
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to load book '" + String.valueOf(entry.getKey()) + "'", e);
                BookErrorManager.get().reset();
            }
        }
        for (Map.Entry<class_2960, JsonObject> entry : categoryJsons.entrySet()) {
            try {
                class_2960 categoryId;
                pathParts = entry.getKey().method_12832().split("/");
                bookId = class_2960.method_60655((String)entry.getKey().method_12836(), (String)pathParts[0]);
                BookErrorManager.get().setCurrentBookId(bookId);
                BookErrorManager.get().getContextHelper().categoryId = categoryId = class_2960.method_60655((String)entry.getKey().method_12836(), (String)Arrays.stream(pathParts).skip(2L).collect(Collectors.joining("/")));
                if (!this.testConditionOnLoad(categoryId, entry.getValue(), this.registries)) continue;
                BookCategory category = this.loadCategory(categoryId, entry.getValue(), this.registries);
                book = this.books.get(bookId);
                book.addCategory(category);
                BookErrorManager.get().reset();
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to load category '" + String.valueOf(entry.getKey()) + "'", e);
                BookErrorManager.get().reset();
            }
        }
        for (Map.Entry<class_2960, JsonObject> entry : entryJsons.entrySet()) {
            try {
                class_2960 entryId;
                pathParts = entry.getKey().method_12832().split("/");
                bookId = class_2960.method_60655((String)entry.getKey().method_12836(), (String)pathParts[0]);
                BookErrorManager.get().setCurrentBookId(bookId);
                BookErrorManager.get().getContextHelper().entryId = entryId = class_2960.method_60655((String)entry.getKey().method_12836(), (String)Arrays.stream(pathParts).skip(2L).collect(Collectors.joining("/")));
                if (!this.testConditionOnLoad(entryId, entry.getValue(), this.registries)) continue;
                BookEntry bookEntry = this.loadEntry(entryId, entry.getValue(), this.books.get(bookId).autoAddReadConditions(), this.registries);
                book = this.books.get(bookId);
                BookCategory category = book.getCategory(bookEntry.getCategoryId());
                category.addEntry(bookEntry);
                BookErrorManager.get().reset();
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to load entry '" + String.valueOf(entry.getKey()) + "'", e);
                BookErrorManager.get().reset();
            }
        }
        for (Map.Entry<class_2960, JsonObject> entry : commandJsons.entrySet()) {
            try {
                pathParts = entry.getKey().method_12832().split("/");
                bookId = class_2960.method_60655((String)entry.getKey().method_12836(), (String)pathParts[0]);
                BookErrorManager.get().setCurrentBookId(bookId);
                BookErrorManager.get().setContext("Loading Command JSON", new Object[0]);
                class_2960 commandId = class_2960.method_60655((String)entry.getKey().method_12836(), (String)Arrays.stream(pathParts).skip(2L).collect(Collectors.joining("/")));
                BookErrorManager.get().setContext("Loading Command JSON: " + String.valueOf(commandId), new Object[0]);
                BookCommand command = this.loadCommand(commandId, entry.getValue());
                book = this.books.get(bookId);
                book.addCommand(command);
                BookErrorManager.get().reset();
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to load command '" + String.valueOf(entry.getKey()) + "'", e);
                BookErrorManager.get().reset();
            }
        }
        BookErrorManager.get().reset();
        this.onLoadingComplete();
    }

    public static class Client
    extends LegacySimpleJsonResourceReloadListener {
        private static final Client instance = new Client();
        private static final class_2960 fallbackFont = class_2960.method_60655((String)"minecraft", (String)"default");
        private final Map<class_2960, class_8779> advancements = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        private final Object2FloatOpenHashMap<BookTextHolder.ScaleCacheKey> bookTextHolderScaleCache = new Object2FloatOpenHashMap();
        private boolean isFallbackLocale;
        private boolean isFontInitialized;

        public Client() {
            super(GSON, BookDataManager.FOLDER);
            this.bookTextHolderScaleCache.defaultReturnValue(-1.0f);
        }

        public static Client get() {
            return instance;
        }

        public void resetUseFallbackFont() {
            this.isFontInitialized = false;
        }

        public boolean useFallbackFont() {
            if (!this.isFontInitialized) {
                this.isFontInitialized = true;
                String locale = class_310.method_1551().method_1526().method_4669();
                this.isFallbackLocale = ClientServices.CLIENT_CONFIG.fontFallbackLocales().stream().anyMatch(l -> l.equals(locale));
            }
            return this.isFallbackLocale;
        }

        public class_2960 safeFont(class_2960 requested) {
            return this.useFallbackFont() ? fallbackFont : requested;
        }

        public class_8779 getAdvancement(class_2960 id) {
            return this.advancements.get(id);
        }

        public void putScale(BookTextHolder holder, int width, int height, float scale) {
            this.bookTextHolderScaleCache.put((Object)new BookTextHolder.ScaleCacheKey(holder, width, height), scale);
        }

        public float getScale(BookTextHolder holder, int width, int height) {
            return this.bookTextHolderScaleCache.getFloat((Object)new BookTextHolder.ScaleCacheKey(holder, width, height));
        }

        public void addAdvancement(class_8779 advancement) {
            this.advancements.put(advancement.comp_1919(), advancement);
        }

        protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
            this.resetUseFallbackFont();
            this.advancements.clear();
            this.bookTextHolderScaleCache.clear();
        }
    }
}

