/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.book.conditions.BookAdvancementCondition;
import com.klikli_dev.modonomicon.book.conditions.BookAndCondition;
import com.klikli_dev.modonomicon.book.conditions.BookCategoryHasVisibleEntriesCondition;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryReadCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryUnlockedCondition;
import com.klikli_dev.modonomicon.book.conditions.BookFalseCondition;
import com.klikli_dev.modonomicon.book.conditions.BookModLoadedCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.conditions.BookOrCondition;
import com.klikli_dev.modonomicon.book.conditions.BookTrueCondition;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.entries.CategoryLinkBookEntry;
import com.klikli_dev.modonomicon.book.entries.EntryLinkBookEntry;
import com.klikli_dev.modonomicon.book.page.BookBlastingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookCampfireCookingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookCraftingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookEmptyPage;
import com.klikli_dev.modonomicon.book.page.BookEntityPage;
import com.klikli_dev.modonomicon.book.page.BookImagePage;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.book.page.BookSmeltingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmithingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSmokingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookSpotlightPage;
import com.klikli_dev.modonomicon.book.page.BookStonecuttingRecipePage;
import com.klikli_dev.modonomicon.book.page.BookTextPage;
import com.klikli_dev.modonomicon.data.BookConditionJsonLoader;
import com.klikli_dev.modonomicon.data.BookDynamicTextMacroLoader;
import com.klikli_dev.modonomicon.data.BookEntryJsonLoader;
import com.klikli_dev.modonomicon.data.BookPageJsonLoader;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.NetworkLoader;
import com.klikli_dev.modonomicon.multiblock.DenseMultiblock;
import com.klikli_dev.modonomicon.multiblock.SparseMultiblock;
import com.klikli_dev.modonomicon.multiblock.matcher.AnyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.BlockMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.BlockStateMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.BlockStatePropertyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.klikli_dev.modonomicon.multiblock.matcher.PredicateMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.TagMatcher;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class LoaderRegistry {
    private static final Multimap<class_2960, BookDynamicTextMacroLoader> dynamicTextMacroLoaders = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private static final Map<class_2960, BookEntryJsonLoader<? extends BookEntry>> entryTypeJsonLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, NetworkLoader<? extends BookEntry>> entryTypeNetworkLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, BookPageJsonLoader<? extends BookPage>> pageJsonLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, NetworkLoader<? extends BookPage>> pageNetworkLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, BookConditionJsonLoader<? extends BookCondition>> conditionJsonLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, NetworkLoader<? extends BookCondition>> conditionNetworkLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, JsonLoader<? extends Multiblock>> multiblockJsonLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, NetworkLoader<? extends Multiblock>> multiblockNetworkLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, JsonLoader<? extends StateMatcher>> stateMatcherJsonLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, NetworkLoader<? extends StateMatcher>> stateMatcherNetworkLoaders = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Map<class_2960, TriPredicate<class_1922, class_2338, class_2680>> predicates = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());

    public static void registerLoaders() {
        LoaderRegistry.registerDefaultBookEntryTypes();
        LoaderRegistry.registerDefaultPageLoaders();
        LoaderRegistry.registerDefaultConditionLoaders();
        LoaderRegistry.registerDefaultPredicates();
        LoaderRegistry.registerDefaultStateMatcherLoaders();
        LoaderRegistry.registerDefaultMultiblockLoaders();
        LoaderRegistry.registerDynamicTextMacroLoader(Modonomicon.loc("demo"), () -> Map.of("my.test.macro", String.valueOf(new Random().nextDouble())));
    }

    private static void registerDefaultBookEntryTypes() {
        LoaderRegistry.registerEntryType(ModonomiconConstants.Data.EntryType.CONTENT, BookContentEntry::fromJson, BookContentEntry::fromNetwork);
        LoaderRegistry.registerEntryType(ModonomiconConstants.Data.EntryType.CATEGORY_LINK, CategoryLinkBookEntry::fromJson, CategoryLinkBookEntry::fromNetwork);
        LoaderRegistry.registerEntryType(ModonomiconConstants.Data.EntryType.ENTRY_LINK, EntryLinkBookEntry::fromJson, EntryLinkBookEntry::fromNetwork);
    }

    private static void registerDefaultPageLoaders() {
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.TEXT, BookTextPage::fromJson, BookTextPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.MULTIBLOCK, BookMultiblockPage::fromJson, BookMultiblockPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.CRAFTING_RECIPE, BookCraftingRecipePage::fromJson, BookCraftingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.SMELTING_RECIPE, BookSmeltingRecipePage::fromJson, BookSmeltingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.SMOKING_RECIPE, BookSmokingRecipePage::fromJson, BookSmokingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.CAMPFIRE_COOKING_RECIPE, BookCampfireCookingRecipePage::fromJson, BookCampfireCookingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.BLASTING_RECIPE, BookBlastingRecipePage::fromJson, BookBlastingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.STONECUTTING_RECIPE, BookStonecuttingRecipePage::fromJson, BookStonecuttingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.SMITHING_RECIPE, BookSmithingRecipePage::fromJson, BookSmithingRecipePage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.SPOTLIGHT, BookSpotlightPage::fromJson, BookSpotlightPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.EMPTY, BookEmptyPage::fromJson, BookEmptyPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.ENTITY, BookEntityPage::fromJson, BookEntityPage::fromNetwork);
        LoaderRegistry.registerPageLoader(ModonomiconConstants.Data.Page.IMAGE, BookImagePage::fromJson, BookImagePage::fromNetwork);
    }

    private static void registerDefaultConditionLoaders() {
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.NONE, BookNoneCondition::fromJson, BookNoneCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.ADVANCEMENT, BookAdvancementCondition::fromJson, BookAdvancementCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.ENTRY_UNLOCKED, BookEntryUnlockedCondition::fromJson, BookEntryUnlockedCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.ENTRY_READ, BookEntryReadCondition::fromJson, BookEntryReadCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.OR, BookOrCondition::fromJson, BookOrCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.AND, BookAndCondition::fromJson, BookAndCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.TRUE, BookTrueCondition::fromJson, BookTrueCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.FALSE, BookFalseCondition::fromJson, BookFalseCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.MOD_LOADED, BookModLoadedCondition::fromJson, BookModLoadedCondition::fromNetwork);
        LoaderRegistry.registerConditionLoader(ModonomiconConstants.Data.Condition.CATEGORY_HAS_VISIBLE_ENTRIES, BookCategoryHasVisibleEntriesCondition::fromJson, BookCategoryHasVisibleEntriesCondition::fromNetwork);
    }

    private static void registerDefaultMultiblockLoaders() {
        LoaderRegistry.registerMultiblockLoader(DenseMultiblock.TYPE, DenseMultiblock::fromJson, DenseMultiblock::fromNetwork);
        LoaderRegistry.registerMultiblockLoader(SparseMultiblock.TYPE, SparseMultiblock::fromJson, SparseMultiblock::fromNetwork);
    }

    private static void registerDefaultStateMatcherLoaders() {
        LoaderRegistry.registerStateMatcherLoader(AnyMatcher.TYPE, AnyMatcher::fromJson, AnyMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(BlockMatcher.TYPE, BlockMatcher::fromJson, BlockMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(BlockStateMatcher.TYPE, BlockStateMatcher::fromJson, BlockStateMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(BlockStatePropertyMatcher.TYPE, BlockStatePropertyMatcher::fromJson, BlockStatePropertyMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(DisplayOnlyMatcher.TYPE, DisplayOnlyMatcher::fromJson, DisplayOnlyMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(PredicateMatcher.TYPE, PredicateMatcher::fromJson, PredicateMatcher::fromNetwork);
        LoaderRegistry.registerStateMatcherLoader(TagMatcher.TYPE, TagMatcher::fromJson, TagMatcher::fromNetwork);
    }

    private static void registerDefaultPredicates() {
        LoaderRegistry.registerPredicate(Matchers.AIR.getPredicateId(), (getter, pos, state) -> state.method_26215());
        LoaderRegistry.registerPredicate(Modonomicon.loc("non_solid"), (getter, pos, state) -> !state.method_51367());
    }

    public static void registerDynamicTextMacroLoader(class_2960 forBookId, BookDynamicTextMacroLoader loader) {
        dynamicTextMacroLoaders.put((Object)forBookId, (Object)loader);
    }

    public static void registerEntryType(class_2960 id, BookEntryJsonLoader<? extends BookEntry> jsonLoader, NetworkLoader<? extends BookEntry> networkLoader) {
        entryTypeJsonLoaders.put(id, jsonLoader);
        entryTypeNetworkLoaders.put(id, networkLoader);
    }

    public static void registerPageLoader(class_2960 id, BookPageJsonLoader<? extends BookPage> jsonLoader, NetworkLoader<? extends BookPage> networkLoader) {
        pageJsonLoaders.put(id, jsonLoader);
        pageNetworkLoaders.put(id, networkLoader);
    }

    public static void registerConditionLoader(class_2960 id, BookConditionJsonLoader<? extends BookCondition> jsonLoader, NetworkLoader<? extends BookCondition> networkLoader) {
        conditionJsonLoaders.put(id, jsonLoader);
        conditionNetworkLoaders.put(id, networkLoader);
    }

    public static void registerMultiblockLoader(class_2960 id, JsonLoader<? extends Multiblock> jsonLoader, NetworkLoader<? extends Multiblock> networkLoader) {
        multiblockJsonLoaders.put(id, jsonLoader);
        multiblockNetworkLoaders.put(id, networkLoader);
    }

    public static void registerStateMatcherLoader(class_2960 id, JsonLoader<? extends StateMatcher> jsonLoader, NetworkLoader<? extends StateMatcher> networkLoader) {
        stateMatcherJsonLoaders.put(id, jsonLoader);
        stateMatcherNetworkLoaders.put(id, networkLoader);
    }

    public static void registerPredicate(class_2960 id, TriPredicate<class_1922, class_2338, class_2680> predicate) {
        predicates.put(id, predicate);
    }

    public static BookEntryJsonLoader<? extends BookEntry> getEntryJsonLoader(class_2960 id) {
        BookEntryJsonLoader<? extends BookEntry> loader = entryTypeJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for entry type " + String.valueOf(id));
        }
        return loader;
    }

    public static NetworkLoader<? extends BookEntry> getEntryNetworkLoader(class_2960 id) {
        NetworkLoader<? extends BookEntry> loader = entryTypeNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for entry type " + String.valueOf(id));
        }
        return loader;
    }

    public static JsonLoader<? extends StateMatcher> getStateMatcherJsonLoader(class_2960 id) {
        JsonLoader<? extends StateMatcher> loader = stateMatcherJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for state matcher type " + String.valueOf(id));
        }
        return loader;
    }

    public static NetworkLoader<? extends StateMatcher> getStateMatcherNetworkLoader(class_2960 id) {
        NetworkLoader<? extends StateMatcher> loader = stateMatcherNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for state matcher type " + String.valueOf(id));
        }
        return loader;
    }

    public static TriPredicate<class_1922, class_2338, class_2680> getPredicate(class_2960 id) {
        TriPredicate<class_1922, class_2338, class_2680> predicate = predicates.get(id);
        if (predicate == null) {
            throw new IllegalArgumentException("No predicated registered for id " + String.valueOf(id));
        }
        return predicate;
    }

    public static BookPageJsonLoader<? extends BookPage> getPageJsonLoader(class_2960 id) {
        BookPageJsonLoader<? extends BookPage> loader = pageJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for page type " + String.valueOf(id));
        }
        return loader;
    }

    public static NetworkLoader<? extends BookPage> getPageNetworkLoader(class_2960 id) {
        NetworkLoader<? extends BookPage> loader = pageNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for page type " + String.valueOf(id));
        }
        return loader;
    }

    public static BookConditionJsonLoader<? extends BookCondition> getConditionJsonLoader(class_2960 id) {
        BookConditionJsonLoader<? extends BookCondition> loader = conditionJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for condition type " + String.valueOf(id));
        }
        return loader;
    }

    public static NetworkLoader<? extends BookCondition> getConditionNetworkLoader(class_2960 id) {
        NetworkLoader<? extends BookCondition> loader = conditionNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for condition type " + String.valueOf(id));
        }
        return loader;
    }

    public static JsonLoader<? extends Multiblock> getMultiblockJsonLoader(class_2960 id) {
        JsonLoader<? extends Multiblock> loader = multiblockJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for multiblock type " + String.valueOf(id));
        }
        return loader;
    }

    public static NetworkLoader<? extends Multiblock> getMultiblockNetworkLoader(class_2960 id) {
        NetworkLoader<? extends Multiblock> loader = multiblockNetworkLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No network loader registered for multiblock type " + String.valueOf(id));
        }
        return loader;
    }

    public static Collection<BookDynamicTextMacroLoader> getDynamicTextMacroLoaders(class_2960 bookId) {
        return dynamicTextMacroLoaders.get((Object)bookId);
    }
}

