/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.item;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.registry.DataComponentRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9336;
import org.jetbrains.annotations.NotNull;

public class ModonomiconItem
extends class_1792 {
    public ModonomiconItem(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public static Book getBook(class_1799 stack) {
        class_2960 res = ModonomiconItem.getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookDataManager.get().getBook(res);
    }

    public static class_2960 getBookId(class_1799 stack) {
        return (class_2960)stack.method_58694(DataComponentRegistry.BOOK_ID.get());
    }

    public static void setBookClosed(class_1799 stack) {
        if (stack != null) {
            stack.method_57379(DataComponentRegistry.BOOK_OPEN.get(), (Object)false);
        }
    }

    public static boolean isBookOpen(class_1799 stack) {
        if (stack != null && stack.method_57826(DataComponentRegistry.BOOK_OPEN.get())) {
            Boolean val = (Boolean)stack.method_58694(DataComponentRegistry.BOOK_OPEN.get());
            return Boolean.TRUE.equals(val);
        }
        return false;
    }

    public Book getBookFor(class_1799 stack) {
        return ModonomiconItem.getBook(stack);
    }

    @NotNull
    public class_1269 method_7836(class_1937 pLevel, class_1657 pPlayer, @NotNull class_1268 pUsedHand) {
        class_1799 itemInHand = pPlayer.method_5998(pUsedHand);
        itemInHand.method_57379(DataComponentRegistry.BOOK_OPEN.get(), (Object)true);
        if (pLevel.method_8608()) {
            if (itemInHand.method_58694(DataComponentRegistry.BOOK_ID.get()) != null) {
                Book book = ModonomiconItem.getBook(itemInHand);
                BookGuiManager.get().openBook(BookAddress.defaultFor(book));
            } else {
                Modonomicon.LOG.error("ModonomiconItem: ItemStack has no tag!");
            }
        }
        return class_1269.field_5812;
    }

    public class_2561 method_7864(class_1799 pStack) {
        Book book = this.getBookFor(pStack);
        if (book != null) {
            return class_2561.method_43471((String)book.getName());
        }
        return super.method_7864(pStack);
    }

    public void method_67187(@NotNull class_1799 itemStack, @NotNull class_1792.class_9635 tooltipContext, @NotNull class_10712 tooltipDisplay, @NotNull Consumer<class_2561> consumer, @NotNull class_1836 tooltipFlag) {
        super.method_67187(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        Book book = ModonomiconItem.getBook(itemStack);
        if (book != null) {
            if (tooltipFlag.method_8035()) {
                consumer.accept((class_2561)class_2561.method_43470((String)"Book ID: ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)book.getId().toString()).method_27692(class_124.field_1061)));
            }
            if (!book.getTooltip().isBlank()) {
                consumer.accept((class_2561)class_2561.method_43471((String)book.getTooltip()).method_27692(class_124.field_1080));
            }
        } else {
            class_2487 compound = new class_2487();
            for (class_9336 entry : itemStack.method_57353()) {
                class_2520 tag = (class_2520)entry.method_57943((DynamicOps)class_2509.field_11560).getOrThrow();
                class_2960 key = class_7923.field_49658.method_10221((Object)entry.comp_2443());
                compound.method_10566(key.toString(), tag);
            }
            consumer.accept((class_2561)class_2561.method_43469((String)"tooltip.modonomicon.no_book_found_for_stack", (Object[])new Object[]{class_2512.method_32270((class_2520)compound)}).method_27692(class_124.field_1063));
        }
    }
}

