/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.multiblock.matcher;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class PredicateMatcher
implements StateMatcher {
    public static final class_2960 TYPE = Modonomicon.loc("predicate");
    private final class_2680 displayState;
    private final class_2960 predicateId;
    private final Supplier<TriPredicate<class_1922, class_2338, class_2680>> predicate;
    private final boolean countsTowardsTotalBlocks;

    protected PredicateMatcher(class_2680 displayState, class_2960 predicateId, boolean countsTowardsTotalBlocks) {
        this.displayState = displayState;
        this.predicateId = predicateId;
        this.predicate = Suppliers.memoize(() -> LoaderRegistry.getPredicate(this.predicateId));
        this.countsTowardsTotalBlocks = countsTowardsTotalBlocks;
    }

    public static PredicateMatcher fromJson(JsonObject json, class_7225.class_7874 provider) {
        try {
            class_2680 displayState = class_2259.method_41955((class_7225)class_7923.field_41175, (StringReader)new StringReader(class_3518.method_15265((JsonObject)json, (String)"display")), (boolean)false).comp_622();
            class_2960 predicateId = class_2960.method_60654((String)class_3518.method_15265((JsonObject)json, (String)"predicate"));
            boolean countsTowardsTotalBlocks = class_3518.method_15258((JsonObject)json, (String)"counts_towards_total_blocks", (boolean)true);
            return new PredicateMatcher(displayState, predicateId, countsTowardsTotalBlocks);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for PredicateMatcher.", e);
        }
    }

    public static PredicateMatcher fromNetwork(class_2540 buffer) {
        try {
            class_2680 displayState = class_2259.method_41955((class_7225)class_7923.field_41175, (StringReader)new StringReader(buffer.method_19772()), (boolean)false).comp_622();
            class_2960 predicateId = buffer.method_10810();
            boolean countsTowardsTotalBlocks = buffer.readBoolean();
            return new PredicateMatcher(displayState, predicateId, countsTowardsTotalBlocks);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse PredicateMatcher from network.", e);
        }
    }

    public class_2960 getPredicateId() {
        return this.predicateId;
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }

    @Override
    public class_2680 getDisplayedState(long ticks) {
        return this.displayState;
    }

    @Override
    public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
        return (TriPredicate)this.predicate.get();
    }

    @Override
    public void toNetwork(class_2540 buffer) {
        buffer.method_10814(class_2259.method_9685((class_2680)this.displayState));
        buffer.method_10814(this.predicateId.toString());
        buffer.method_52964(this.countsTowardsTotalBlocks);
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return this.countsTowardsTotalBlocks;
    }

    public int hashCode() {
        return Objects.hash(this.predicateId, this.displayState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateMatcher that = (PredicateMatcher)o;
        return this.predicateId.equals((Object)that.predicateId) && this.displayState.equals((Object)that.displayState);
    }
}

