/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.google.common.collect.Lists;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.networking.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_5219;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class ReloadResourcesDoneMessage
implements Message {
    public static final ReloadResourcesDoneMessage INSTANCE = new ReloadResourcesDoneMessage();
    public static final class_8710.class_9154<ReloadResourcesDoneMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"modonomicon", (String)"reload_resources_done"));
    public static final class_9139<class_9129, ReloadResourcesDoneMessage> STREAM_CODEC = class_9139.method_56431((Object)INSTANCE);

    private ReloadResourcesDoneMessage() {
    }

    private static Collection<String> discoverNewPacks(class_3283 pPackRepository, class_5219 pWorldData, Collection<String> pSelectedIds) {
        pPackRepository.method_14445();
        ArrayList collection = Lists.newArrayList(pSelectedIds);
        List collection1 = pWorldData.method_29589().comp_1010().method_29550();
        for (String s : pPackRepository.method_29206()) {
            if (collection1.contains(s) || collection.contains(s)) continue;
            collection.add(s);
        }
        return collection;
    }

    public static void reloadPacks(Collection<String> pSelectedIds, class_3222 player, MinecraftServer server) {
        ((CompletableFuture)server.method_29439(pSelectedIds).exceptionally(error -> {
            Modonomicon.LOG.warn("Failed to execute reload", error);
            player.method_64398((class_2561)class_2561.method_43471((String)"commands.reload.failure").method_27692(class_124.field_1061));
            return null;
        })).thenRun(() -> {
            BookUnlockStateManager.get().updateAndSyncFor(player);
            player.method_64398((class_2561)class_2561.method_43471((String)"modonomicon.command.success.reload_requested").method_27692(class_124.field_1060));
        });
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        if (!player.method_64475(2)) {
            return;
        }
        class_3283 packrepository = minecraftServer.method_3836();
        class_5219 worlddata = minecraftServer.method_27728();
        Collection selectedIds = packrepository.method_29210();
        Collection<String> packs = ReloadResourcesDoneMessage.discoverNewPacks(packrepository, worlddata, selectedIds);
        ReloadResourcesDoneMessage.reloadPacks(packs, player, minecraftServer);
    }
}

