/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class SaveEntryStateMessage
implements Message {
    public static final class_8710.class_9154<SaveEntryStateMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"modonomicon", (String)"save_entry_state"));
    public static final class_9139<class_9129, SaveEntryStateMessage> STREAM_CODEC = class_8710.method_56484(SaveEntryStateMessage::encode, SaveEntryStateMessage::new);
    public BookEntry entry;
    public int openPagesIndex;

    public SaveEntryStateMessage(BookEntry entry, EntryVisualState state) {
        this(entry, state.openPagesIndex);
    }

    public SaveEntryStateMessage(BookEntry entry, int openPagesIndex) {
        this.entry = entry;
        this.openPagesIndex = openPagesIndex;
    }

    public SaveEntryStateMessage(class_9129 buf) {
        this.decode(buf);
    }

    private void encode(class_9129 buf) {
        buf.method_10812(this.entry.getBook().getId());
        buf.method_10812(this.entry.getId());
        buf.method_10804(this.openPagesIndex);
    }

    private void decode(class_9129 buf) {
        this.entry = BookDataManager.get().getBook(buf.method_10810()).getEntry(buf.method_10810());
        this.openPagesIndex = buf.method_10816();
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        EntryVisualState currentState = BookVisualStateManager.get().getEntryStateFor((class_1657)player, this.entry);
        currentState.openPagesIndex = this.openPagesIndex;
        BookVisualStateManager.get().setEntryStateFor(player, this.entry, currentState);
        BookVisualStateManager.get().syncFor(player);
    }
}

