/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.BookModel;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.config.ClientConfig;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.datagen.DataGenerators;
import com.klikli_dev.modonomicon.integration.LecternIntegration;
import com.klikli_dev.modonomicon.item.IsBookOpen;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.registry.CommandRegistry;
import com.klikli_dev.modonomicon.registry.CreativeModeTabRegistry;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperties;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="modonomicon")
public class ModonomiconNeo {
    public ModonomiconNeo(IEventBus modEventBus, ModContainer modContainer) {
        Modonomicon.init();
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.get().spec);
        CreativeModeTabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(Networking::register);
        modEventBus.addListener(CreativeModeTabRegistry::onCreativeModeTabBuildContents);
        NeoForge.EVENT_BUS.addListener(e -> {
            BookDataManager.get().registries((HolderLookup.Provider)e.getRegistryAccess());
            e.addListener(Modonomicon.loc("book_data_manager"), (PreparableReloadListener)BookDataManager.get());
            MultiblockDataManager.get().registries((HolderLookup.Provider)e.getRegistryAccess());
            e.addListener(Modonomicon.loc("multiblock_data_manager"), (PreparableReloadListener)MultiblockDataManager.get());
        });
        NeoForge.EVENT_BUS.addListener(e -> CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        NeoForge.EVENT_BUS.addListener(e -> CommandRegistry.registerClientCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        NeoForge.EVENT_BUS.addListener(e -> {
            if (e.getPlayer() != null) {
                BookDataManager.get().onDatapackSync(e.getPlayer());
                MultiblockDataManager.get().onDatapackSync(e.getPlayer());
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            Entity patt0$temp = e.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                BookUnlockStateManager.get().updateAndSyncFor(player);
                BookVisualStateManager.get().syncFor(player);
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            Level level;
            LevelAccessor patt0$temp = e.getLevel();
            if (patt0$temp instanceof Level && (level = (Level)patt0$temp).dimension() == Level.OVERWORLD) {
                BookUnlockStateManager.get().saveData = null;
                BookVisualStateManager.get().saveData = null;
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> BookUnlockStateManager.get().onAdvancement((ServerPlayer)e.getEntity()));
        NeoForge.EVENT_BUS.addListener(e -> BookUnlockStateManager.get().onServerTickEnd(e.getServer()));
        modEventBus.addListener(DataGenerators::gatherData);
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            modEventBus.addListener(Client::onClientSetup);
            modEventBus.addListener(Client::onRegisterGuiOverlays);
            modEventBus.addListener(Client::onModifyBakingResult);
            modEventBus.addListener(e -> e.addListener(Modonomicon.loc("book_data_manager_client"), (PreparableReloadListener)BookDataManager.Client.get()));
            Client.registerConfigScreen(modContainer);
        }
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        LoaderRegistry.registerLoaders();
        NeoForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = LecternIntegration.rightClick(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            if (result.consumesAction()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
    }

    public static class Client {
        public static void onClientSetup(FMLClientSetupEvent event) {
            PageRendererRegistry.registerPageRenderers();
            NeoForge.EVENT_BUS.addListener(e -> {
                ClientTicks.endClientTick(Minecraft.getInstance());
                MultiblockPreviewRenderer.onClientTick(Minecraft.getInstance());
            });
            NeoForge.EVENT_BUS.addListener(e -> ClientTicks.renderTickStart(e.getPartialTick().getGameTimeDeltaPartialTick(true)));
            NeoForge.EVENT_BUS.addListener(e -> ClientTicks.renderTickEnd());
            NeoForge.EVENT_BUS.addListener(e -> {
                InteractionResult result = MultiblockPreviewRenderer.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
                if (result.consumesAction()) {
                    e.setCanceled(true);
                    e.setCancellationResult(result);
                }
            });
            NeoForge.EVENT_BUS.addListener(e -> MultiblockPreviewRenderer.extractRenderState(e.getRenderState()));
            NeoForge.EVENT_BUS.addListener(e -> MultiblockPreviewRenderer.onRenderLevelLastEvent(e.getLevelRenderState(), e.getPoseStack()));
            event.enqueueWork(() -> ConditionalItemModelProperties.ID_MAPPER.put((Object)Modonomicon.loc("is_book_open"), IsBookOpen.MAP_CODEC));
        }

        public static void registerConfigScreen(ModContainer modContainer) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }

        public static void onRegisterGuiOverlays(RegisterGuiLayersEvent event) {
            event.registerBelow(VanillaGuiLayers.BOSS_OVERLAY, Modonomicon.loc("multiblock_hud"), (guiGraphics, partialTicks) -> MultiblockPreviewRenderer.onRenderHUD(guiGraphics, partialTicks.getGameTimeDeltaPartialTick(true)));
        }

        public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
            BookModel.replace(event.getBakingResult().itemStackModels());
        }
    }
}

