/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookScreenWithButtons;
import com.klikli_dev.modonomicon.client.gui.book.button.ArrowButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ExitButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public abstract class BookPaginatedScreen
extends Screen
implements BookScreenWithButtons {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int BOOK_BACKGROUND_WIDTH = 272;
    public static final int BOOK_BACKGROUND_HEIGHT = 178;
    protected int bookLeft;
    protected int bookTop;
    protected boolean addExitButton;

    public BookPaginatedScreen(Component component) {
        this(component, true);
    }

    public BookPaginatedScreen(Component component, boolean addExitButton) {
        super(component);
        this.addExitButton = addExitButton;
    }

    protected void init() {
        this.bookLeft = (this.width - 272) / 2;
        this.bookTop = (this.height - 178) / 2;
        this.initNavigationButtons();
    }

    protected void initNavigationButtons() {
        this.addRenderableWidget((GuiEventListener)new ArrowButton(this, this.bookLeft - 4, this.bookTop + 180 - 6, true, () -> this.canSeeArrowButton(true), this::handleArrowButton));
        this.addRenderableWidget((GuiEventListener)new ArrowButton(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false, () -> this.canSeeArrowButton(false), this::handleArrowButton));
        if (this.addExitButton) {
            this.addRenderableWidget((GuiEventListener)new ExitButton(this, this.bookLeft + 272 - 10, this.bookTop - 2, this::handleExitButton));
        }
    }

    public void handleExitButton(Button button) {
        this.onClose();
    }

    public abstract boolean canSeeArrowButton(boolean var1);

    public void handleArrowButton(Button button) {
        this.flipPage(((ArrowButton)button).left, true);
    }

    protected abstract void flipPage(boolean var1, boolean var2);

    protected boolean isClickOutsideEntry(double pMouseX, double pMouseY) {
        return pMouseX < (double)(this.bookLeft - 20) || pMouseX > (double)(this.bookLeft + 272 + 20) || pMouseY < (double)(this.bookTop - 20) || pMouseY > (double)(this.bookTop + 180 + 20);
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 259) {
            this.back();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean canSeeBackButton() {
        return BookGuiManager.get().getHistorySize(this.getBook().getId()) > 0;
    }

    public void handleBackButton(Button button) {
        this.back();
    }

    public void back() {
        if (BookGuiManager.get().getHistorySize(this.getBook().getId()) > 0) {
            BookAddress lastPage = BookGuiManager.get().popHistory(this.getBook().getId());
            BookGuiManager.get().openEntry(lastPage.bookId(), lastPage.categoryId(), lastPage.entryId(), lastPage.page());
        } else {
            this.onClose();
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        if (this.isClickOutsideEntry(event.x(), event.y())) {
            this.onClose();
            return true;
        }
        if (event.button() == 1) {
            this.back();
            return true;
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0) {
            this.flipPage(false, true);
        } else if (scrollY > 0.0) {
            this.flipPage(true, true);
        }
        return true;
    }
}

