/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;

public class ShowBookmarksButton
extends Button {
    private final BookParentScreen parent;
    private final int scissorX;

    public ShowBookmarksButton(BookParentScreen parent, int pX, int pY, int scissorX, int width, int height, Button.OnPress pOnPress, Tooltip tooltip) {
        super(pX, pY, width, height, (Component)Component.literal((String)""), pOnPress, Button.DEFAULT_NARRATION);
        this.setTooltip(tooltip);
        this.scissorX = scissorX;
        this.parent = parent;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.visible) {
            guiGraphics.pose().pushMatrix();
            int xOffset = this.parent.getBook().getSearchButtonXOffset();
            guiGraphics.pose().translate((float)xOffset, 0.0f);
            int scissorX = this.scissorX + xOffset;
            int texX = 68;
            int texY = 165;
            int renderX = this.getX();
            int scissorWidth = this.width + (this.getX() - this.scissorX);
            int scissorY = ((Screen)this.parent).height - this.getY() - this.height - 1;
            if (this.isHovered()) {
                ++renderX;
                --scissorWidth;
            }
            guiGraphics.enableScissor(scissorX, scissorY, scissorX + scissorWidth, scissorY + 1000);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.parent.getBook().getBookOverviewTexture(), renderX, this.getY(), (float)texX, (float)texY, this.width, this.height, 256, 256);
            guiGraphics.disableScissor();
            guiGraphics.pose().popMatrix();
        }
    }
}

