/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.CommandLink;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.klikli_dev.modonomicon.platform.ClientServices;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface ContentRenderingScreen {
    default public Screen asScreen() {
        return (Screen)this;
    }

    public Book getBook();

    public BookContentEntry getEntry();

    public Font getContentFont();

    public Minecraft getMinecraft();

    public int getTicksInBook();

    public int getBookLeft();

    public int getBookTop();

    public void setTooltipStack(ItemStack var1);

    public void setTooltipStack(FluidHolder var1);

    public boolean isHoveringItemLink();

    public void isHoveringItemLink(boolean var1);

    default public boolean isMouseInRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx;
        double my = absMy;
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    default public void renderItemStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }
        guiGraphics.renderItem(stack, x, y);
        guiGraphics.renderItemDecorations(this.getContentFont(), stack, x, y);
        if (this.isMouseInRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    default public void renderItemStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<ItemStack> stacks) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, stacks, -1);
    }

    default public void renderItemStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<ItemStack> stacks, int countOverride) {
        List<ItemStack> filteredStacks = PageRendererRegistry.filterRenderableItemStacks(stacks);
        if (filteredStacks.size() > 0) {
            ItemStack currentStack = filteredStacks.get(this.getTicksInBook() / 20 % filteredStacks.size());
            this.renderItemStack(guiGraphics, x, y, mouseX, mouseY, countOverride > 0 ? currentStack.copyWithCount(countOverride) : currentStack);
        }
    }

    default public void renderIngredient(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Ingredient ingr) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, ingr.display().resolveForStacks(SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level)), -1);
    }

    default public void renderIngredient(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Ingredient ingr, int countOverride) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, ingr.display().resolveForStacks(SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level)), countOverride);
    }

    default public void renderFluidStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack) {
        this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, stack, 1000);
    }

    default public void renderFluidStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack, int capacity) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }
        guiGraphics.pose().pushMatrix();
        ClientServices.FLUID.drawFluid(guiGraphics, 18, 18, stack, capacity, x, y);
        guiGraphics.pose().popMatrix();
        if (this.isMouseInRange(mouseX, mouseY, x, y, 18, 18)) {
            this.setTooltipStack(stack);
        }
    }

    default public void renderFluidStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks) {
        this.renderFluidStacks(guiGraphics, x, y, mouseX, mouseY, stacks, 1000);
    }

    default public void renderFluidStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks, int capacity) {
        List<FluidHolder> filteredStacks = PageRendererRegistry.filterRenderableFluidStacks(stacks);
        if (filteredStacks.size() > 0) {
            this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, filteredStacks.get(this.getTicksInBook() / 20 % filteredStacks.size()), capacity);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public void renderComponentHoverEffect(GuiGraphics guiGraphics, @Nullable Style style, int mouseX, int mouseY) {
        HoverEvent.EntityTooltipInfo newComponent;
        Object book;
        HoverEvent hoverEvent;
        guiGraphics.pose().pushMatrix();
        Style newStyle = style;
        if (style != null && style.getHoverEvent() != null && style.getHoverEvent().action() == HoverEvent.Action.SHOW_TEXT && (hoverEvent = style.getHoverEvent()) instanceof HoverEvent.ShowText) {
            HoverEvent.ShowText showText = (HoverEvent.ShowText)hoverEvent;
            ClickEvent clickEvent = style.getClickEvent();
            if (clickEvent != null) {
                ClickEvent.RunCommand runCommand;
                Object link;
                ClickEvent.OpenFile openFile;
                if (clickEvent.action() == ClickEvent.Action.OPEN_FILE && clickEvent instanceof ClickEvent.OpenFile && BookLink.isBookLink((openFile = (ClickEvent.OpenFile)clickEvent).path())) {
                    link = BookLink.from(this.getBook(), openFile.path());
                    book = BookDataManager.get().getBook(((BookLink)link).bookId);
                    if (((BookLink)link).entryId != null) {
                        BookEntry entry = ((Book)book).getEntry(((BookLink)link).entryId);
                        Integer page = ((BookLink)link).pageNumber;
                        if (((BookLink)link).pageAnchor != null) {
                            page = entry.getPageNumberForAnchor(((BookLink)link).pageAnchor);
                        }
                        if (!BookUnlockStateManager.get().isUnlockedFor((Player)Minecraft.getInstance().player, entry)) {
                            oldComponent = showText.value();
                            newComponent = Component.translatable((String)"modonomicon.gui.hover.book_link_locked", (Object[])new Object[]{oldComponent, Component.translatable((String)"modonomicon.gui.hover.book_entry_link_locked_info").withStyle(s -> s.withColor(16711701).withBold(Boolean.valueOf(true))).append("\n").append((Component)Component.translatable((String)"modonomicon.gui.hover.book_entry_link_locked_info.hint", (Object[])new Object[]{Component.translatable((String)entry.getCategory().getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)))}).withStyle(s -> s.withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)))});
                            newStyle = style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)newComponent));
                        } else if (page != null && !BookUnlockStateManager.get().isUnlockedFor((Player)Minecraft.getInstance().player, entry.getPages().get(page))) {
                            oldComponent = showText.value();
                            newComponent = Component.translatable((String)"modonomicon.gui.hover.book_link_locked", (Object[])new Object[]{oldComponent, Component.translatable((String)"modonomicon.gui.hover.book_page_link_locked_info").withStyle(s -> s.withColor(16711701).withBold(Boolean.valueOf(true))).append("\n").append((Component)Component.translatable((String)"modonomicon.gui.hover.book_page_link_locked_info.hint", (Object[])new Object[]{Component.translatable((String)entry.getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))), Component.translatable((String)entry.getCategory().getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)))}).withStyle(s -> s.withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)))});
                            newStyle = style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)newComponent));
                        }
                    }
                }
                if (clickEvent.action() == ClickEvent.Action.RUN_COMMAND && clickEvent instanceof ClickEvent.RunCommand && CommandLink.isCommandLink((runCommand = (ClickEvent.RunCommand)clickEvent).command())) {
                    link = CommandLink.from(this.getBook(), runCommand.command());
                    book = BookDataManager.get().getBook(((CommandLink)link).bookId);
                    if (((CommandLink)link).commandId != null) {
                        BookCommand command = ((Book)book).getCommand(((CommandLink)link).commandId);
                        Component oldComponent = showText.value();
                        if (!BookUnlockStateManager.get().canRunFor((Player)Minecraft.getInstance().player, command)) {
                            MutableComponent hoverComponent = Component.translatable((String)"modonomicon.gui.hover.command_link.unavailable").withStyle(ChatFormatting.RED);
                            newStyle = style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hoverComponent));
                            oldComponent = hoverComponent;
                        }
                        if (Minecraft.getInstance().hasShiftDown()) {
                            newComponent = oldComponent.copy().append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)command.getCommand()).withStyle(ChatFormatting.GRAY));
                            newStyle = style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)newComponent));
                        }
                    }
                }
            }
        }
        if ((style = newStyle) != null && style.getHoverEvent() != null) {
            HoverEvent hoverEvent2 = style.getHoverEvent();
            Objects.requireNonNull(hoverEvent2);
            HoverEvent hoverEvent3 = hoverEvent2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HoverEvent.ShowItem.class, HoverEvent.ShowEntity.class, HoverEvent.ShowText.class}, (Object)hoverEvent3, n)) {
                case 0: {
                    ItemStack itemstack;
                    HoverEvent.ShowItem showItem = (HoverEvent.ShowItem)hoverEvent3;
                    try {
                        book = showItem.item();
                        itemstack = book;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (style.getClickEvent() != null) {
                        this.isHoveringItemLink(true);
                    }
                    int backupWidth = this.asScreen().width;
                    this.asScreen().width /= 2;
                    guiGraphics.setTooltipForNextFrame(this.getContentFont(), itemstack, mouseX, mouseY);
                    this.asScreen().width = backupWidth;
                    this.isHoveringItemLink(false);
                    break;
                }
                case 1: {
                    HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo;
                    HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hoverEvent3;
                    {
                        HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo1;
                        hoverevent$entitytooltipinfo = hoverevent$entitytooltipinfo1 = (newComponent = showEntity.entity());
                        if (!this.getMinecraft().options.advancedItemTooltips) break;
                    }
                    guiGraphics.setTooltipForNextFrame(this.getContentFont(), hoverevent$entitytooltipinfo.getTooltipLines().stream().map(Component::getVisualOrderText).toList(), mouseX, mouseY);
                    break;
                }
                case 2: {
                    int width;
                    Component component2;
                    HoverEvent.ShowText showText = (HoverEvent.ShowText)hoverEvent3;
                    {
                        Component component;
                        component2 = component = showText.value();
                        width = this.asScreen().width;
                    }
                    guiGraphics.setTooltipForNextFrame(this.getContentFont(), this.getContentFont().split((FormattedText)component2, width), mouseX, mouseY);
                    break;
                }
            }
        }
        guiGraphics.pose().popMatrix();
    }
}

