/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.node;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.BookVisualState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookScreenWithButtons;
import com.klikli_dev.modonomicon.client.gui.book.bookmarks.BookBookmarksScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.CategoryButton;
import com.klikli_dev.modonomicon.client.gui.book.button.CategoryScrollButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ReadAllButton;
import com.klikli_dev.modonomicon.client.gui.book.button.SearchButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ShowBookmarksButton;
import com.klikli_dev.modonomicon.client.gui.book.node.BookCategoryNodeScreen;
import com.klikli_dev.modonomicon.client.gui.book.search.BookSearchScreen;
import com.klikli_dev.modonomicon.networking.BookClosedMessage;
import com.klikli_dev.modonomicon.networking.ClickReadAllButtonMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class BookParentNodeScreen
extends Screen
implements BookParentScreen,
BookScreenWithButtons {
    public static final int MAX_CATEGORY_BUTTONS = 13;
    private final Book book;
    private final List<BookCategory> categories;
    private final int frameThicknessW = 14;
    private final int frameThicknessH = 14;
    public int renderMouseXOverride = -1;
    public int renderMouseYOverride = -1;
    private BookCategoryNodeScreen currentCategoryNodeScreen;
    private boolean hasUnreadEntries;
    private boolean hasUnreadUnlockedEntries;
    private int categoryButtonRenderOffset = 0;

    public BookParentNodeScreen(Book book) {
        super((Component)Component.literal((String)""));
        this.minecraft = Minecraft.getInstance();
        this.book = book;
        this.categories = book.getCategoriesSorted();
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    @Override
    public void onDisplay() {
        this.updateUnreadEntriesState();
    }

    protected void updateUnreadEntriesState() {
        this.hasUnreadEntries = this.book.getEntries().values().stream().anyMatch(e -> !BookUnlockStateManager.get().isReadFor((Player)this.minecraft.player, (BookEntry)e));
        this.hasUnreadUnlockedEntries = this.book.getEntries().values().stream().anyMatch(e -> BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, (BookEntry)e) && !BookUnlockStateManager.get().isReadFor((Player)this.minecraft.player, (BookEntry)e));
    }

    public BookCategoryNodeScreen getCurrentCategoryScreen() {
        return this.currentCategoryNodeScreen;
    }

    public void setCurrentCategoryScreen(BookCategoryNodeScreen currentCategoryNodeScreen) {
        this.currentCategoryNodeScreen = currentCategoryNodeScreen;
    }

    @Override
    public Book getBook() {
        return this.book;
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
    }

    public ResourceLocation getBookOverviewTexture() {
        return this.book.getBookOverviewTexture();
    }

    public int getInnerX() {
        int n = (this.width - this.getFrameWidth()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerY() {
        int n = (this.height - this.getFrameHeight()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerWidth() {
        int n = this.getFrameWidth();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getInnerHeight() {
        int n = this.getFrameHeight();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getFrameThicknessW() {
        Objects.requireNonNull(this);
        return 14;
    }

    public int getFrameThicknessH() {
        Objects.requireNonNull(this);
        return 14;
    }

    public int getFrameWidth() {
        return this.width - 60;
    }

    public int getFrameHeight() {
        return this.height - 20;
    }

    protected void renderFrame(GuiGraphics guiGraphics) {
        int width = this.getFrameWidth();
        int height = this.getFrameHeight();
        int x = (this.width - width) / 2;
        int y = (this.height - height) / 2;
        GuiGraphicsExt.blitWithBorder(guiGraphics, RenderPipelines.GUI_TEXTURED, this.book.getFrameTexture(), x, y, 0, 0, width, height, 140, 140, 50, 50, 50, 50);
        this.renderFrameOverlay(guiGraphics, this.book.getTopFrameOverlay(), x + width / 2, y);
        this.renderFrameOverlay(guiGraphics, this.book.getBottomFrameOverlay(), x + width / 2, y + height);
        this.renderFrameOverlay(guiGraphics, this.book.getLeftFrameOverlay(), x, y + height / 2);
        this.renderFrameOverlay(guiGraphics, this.book.getRightFrameOverlay(), x + width, y + height / 2);
    }

    protected void renderFrameOverlay(GuiGraphics guiGraphics, BookFrameOverlay overlay, int x, int y) {
        if (overlay.getFrameWidth() > 0 && overlay.getFrameHeight() > 0) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, overlay.getTexture(), overlay.getFrameX(x), overlay.getFrameY(y), (float)overlay.getFrameU(), (float)overlay.getFrameV(), overlay.getFrameWidth(), overlay.getFrameHeight(), 256, 256);
        }
    }

    protected void onBookCategoryButtonClick(CategoryButton button) {
        BookGuiManager.get().openCategory(button.getCategory(), BookAddress.defaultFor(button.getCategory().getBook()));
    }

    protected void onReadAllButtonClick(ReadAllButton button) {
        if (this.hasUnreadUnlockedEntries && !Minecraft.getInstance().hasShiftDown()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), false));
            this.hasUnreadUnlockedEntries = false;
        } else if (this.hasUnreadEntries && Minecraft.getInstance().hasShiftDown()) {
            Services.NETWORK.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), true));
            this.hasUnreadEntries = false;
        }
    }

    protected boolean canSeeReadAllButton() {
        return this.hasUnreadEntries || this.hasUnreadUnlockedEntries;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        this.getCurrentCategoryScreen().mouseClicked(event, isDoubleClick);
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        return this.getCurrentCategoryScreen().mouseDragged(event, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.getCurrentCategoryScreen().zoom(scrollY);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.renderMouseXOverride != -1 && this.renderMouseYOverride != -1) {
            pMouseX = this.renderMouseXOverride;
            pMouseY = this.renderMouseYOverride;
        }
        this.getCurrentCategoryScreen().renderBackground(guiGraphics);
        this.getCurrentCategoryScreen().render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderFrame(guiGraphics);
        this.getCurrentCategoryScreen().renderEntryTooltips(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.renderMouseXOverride = -1;
        this.renderMouseYOverride = -1;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.getCurrentCategoryScreen().keyPressed(event)) {
            return true;
        }
        if (event.key() == 256) {
            BookGuiManager.get().closeScreenStack(this);
            return true;
        }
        return super.keyPressed(event);
    }

    @Override
    public void onClose() {
    }

    @Override
    public void loadState(BookVisualState state) {
    }

    @Override
    public void saveState(BookVisualState state) {
    }

    private void sendBookClosedPacket(InteractionHand hand) {
        Services.NETWORK.sendToServer(new BookClosedMessage(hand));
    }

    public boolean handleComponentClicked(@Nullable Style pStyle) {
        return super.handleComponentClicked(pStyle);
    }

    @Override
    public void onSyncBookUnlockStatesMessage(SyncBookUnlockStatesMessage message) {
        this.rebuildWidgets();
        this.updateUnreadEntriesState();
    }

    protected void init() {
        super.init();
        int buttonXOffset = -11;
        int buttonYOffset = 30 + this.getBook().getCategoryButtonYOffset();
        int buttonX = (this.width - this.getFrameWidth()) / 2 - this.getFrameThicknessW() + buttonXOffset;
        int buttonY = (this.height - this.getFrameHeight()) / 2 - this.getFrameThicknessH() + buttonYOffset;
        int buttonWidth = (this.width - this.getFrameWidth()) / 2 + buttonXOffset + 6;
        int buttonHeight = 20;
        int buttonSpacing = 2;
        this.updateCategoryButtons(buttonX, buttonY, buttonWidth, buttonHeight, buttonSpacing);
        int readAllButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 - 3;
        int readAllButtonYOffset = 30 + this.getBook().getReadAllButtonYOffset();
        int readAllButtonY = (this.height - this.getFrameHeight()) / 2 + 7 + readAllButtonYOffset;
        ReadAllButton readAllButton = new ReadAllButton(this, readAllButtonX, readAllButtonY, () -> this.hasUnreadUnlockedEntries, this::canSeeReadAllButton, b -> this.onReadAllButtonClick((ReadAllButton)b));
        this.addRenderableWidget((GuiEventListener)readAllButton);
        int searchButtonXOffset = 7;
        int searchButtonYOffset = -30 + this.getBook().getSearchButtonYOffset();
        int searchButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 + searchButtonXOffset;
        int searchButtonY = this.getFrameHeight() + this.getFrameThicknessH() - 7 + searchButtonYOffset;
        int searchButtonWidth = 44;
        int scissorX = this.getFrameWidth() + this.getFrameThicknessW() * 2 + 2;
        SearchButton searchButton = new SearchButton(this, searchButtonX, searchButtonY, scissorX, searchButtonWidth, buttonHeight, b -> this.onSearchButtonClick((SearchButton)b), Tooltip.create((Component)Component.translatable((String)"modonomicon.gui.open_search")));
        this.addRenderableWidget((GuiEventListener)searchButton);
        ShowBookmarksButton showBookmarksButton = new ShowBookmarksButton(this, searchButtonX, searchButtonY -= buttonHeight + 2, scissorX, searchButtonWidth, buttonHeight, b -> this.onShowBookmarksButtonClick((ShowBookmarksButton)b), Tooltip.create((Component)Component.translatable((String)"modonomicon.gui.open_bookmarks")));
        this.addRenderableWidget((GuiEventListener)showBookmarksButton);
    }

    protected void updateCategoryButtons(int buttonX, int buttonY, int buttonWidth, int buttonHeight, int buttonSpacing) {
        int buttonCount = 0;
        int size = this.categories.size();
        for (int i = this.categoryButtonRenderOffset; i < size && buttonCount < 13; ++i) {
            if (!this.categories.get(i).showCategoryButton() || !BookUnlockStateManager.get().isUnlockedFor((Player)this.minecraft.player, this.categories.get(i))) continue;
            CategoryButton button = new CategoryButton(this, this.categories.get(i), buttonX, buttonY + (buttonHeight + buttonSpacing) * buttonCount, buttonWidth, buttonHeight, b -> this.onBookCategoryButtonClick((CategoryButton)b), Tooltip.create((Component)Component.translatable((String)this.categories.get(i).getName())));
            this.addRenderableWidget((GuiEventListener)button);
            ++buttonCount;
        }
        buttonX += 8;
        if (this.categoryButtonRenderOffset > 0) {
            int topScrollButtonY = (this.height - this.getFrameHeight()) / 2 - 5;
            CategoryScrollButton topScrollButton = new CategoryScrollButton(this, buttonX, topScrollButtonY, false, () -> this.categoryButtonRenderOffset > 0, b -> {
                --this.categoryButtonRenderOffset;
                this.rebuildWidgets();
            });
            this.addRenderableWidget((GuiEventListener)topScrollButton);
        }
        if (this.categories.size() > this.categoryButtonRenderOffset + 13) {
            int bottomScrollButtonY = this.getFrameHeight() + this.getFrameThicknessH() - 7 - 3;
            CategoryScrollButton bottomScrollButton = new CategoryScrollButton(this, buttonX, bottomScrollButtonY, true, () -> this.categories.size() > this.categoryButtonRenderOffset + 13, b -> {
                ++this.categoryButtonRenderOffset;
                this.rebuildWidgets();
            });
            this.addRenderableWidget((GuiEventListener)bottomScrollButton);
        }
    }

    protected void onSearchButtonClick(SearchButton button) {
        ClientServices.GUI.pushGuiLayer(new BookSearchScreen(this));
    }

    protected void onShowBookmarksButtonClick(ShowBookmarksButton button) {
        ClientServices.GUI.pushGuiLayer(new BookBookmarksScreen(this));
    }

    public boolean isPauseScreen() {
        return false;
    }
}

