/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render;

import com.klikli_dev.modonomicon.client.render.VertexConsumerWrapper;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.NotNull;

public final class GhostVertexConsumer
extends VertexConsumerWrapper {
    private static final Map<VertexConsumer, VertexConsumer> remappedVertexConsumers = new IdentityHashMap<VertexConsumer, VertexConsumer>();
    private final int alpha;
    private final int white;

    public GhostVertexConsumer(VertexConsumer wrapped, int alpha) {
        super(wrapped);
        this.alpha = alpha;
        this.white = ARGB.color((int)alpha, (int)0xFFFFFF);
    }

    public static VertexConsumer remap(VertexConsumer in) {
        return remappedVertexConsumers.computeIfAbsent(in, type -> new GhostVertexConsumer(in, 102));
    }

    public void addVertex(float x, float y, float z, int color, float u, float v, int overlay, int light, float nx, float ny, float nz) {
        this.parent.addVertex(x, y, z, ARGB.multiply((int)this.white, (int)color), u, v, overlay, light, nx, ny, nz);
    }

    @Override
    @NotNull
    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        return this.parent.setColor(red, green, blue, alpha * this.alpha / 255);
    }
}

