/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.book.page.BookImagePage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.button.SmallArrowButton;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class BookImagePageRenderer
extends BookPageRenderer<BookImagePage>
implements PageWithTextRenderer {
    int index;

    public BookImagePageRenderer(BookImagePage page) {
        super(page);
    }

    public void handleButtonArrow(Button button) {
        boolean left = ((SmallArrowButton)button).left;
        this.index = left ? --this.index : ++this.index;
    }

    @Override
    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        int x = 94;
        int y = 101;
        this.addButton(new SmallArrowButton(parentScreen, x, y, true, () -> this.index > 0, this::handleButtonArrow));
        this.addButton(new SmallArrowButton(parentScreen, x + 10, y, false, () -> this.index < ((BookImagePage)this.page).getImages().length - 1, this::handleButtonArrow));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        Style style;
        if (((BookImagePage)this.page).hasTitle()) {
            this.renderTitle(guiGraphics, ((BookImagePage)this.page).getTitle(), false, 62, 0);
        }
        int textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, ((BookImagePage)this.getPage()).getText(), 0, textY, 124, 155 - textY);
        int x = 9;
        int y = 7;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().scale(0.5f, 0.5f);
        if (((BookImagePage)this.page).useLegacyRendering()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ((BookImagePage)this.page).getImages()[this.index], x * 2 + 6, y * 2 + 6, 0.0f, 0.0f, 200, 200, 256, 256);
        } else {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ((BookImagePage)this.page).getImages()[this.index], x * 2 + 6, y * 2 + 6, 0.0f, 0.0f, 200, 200, 200, 200, 200, 200);
        }
        guiGraphics.pose().scale(2.0f, 2.0f);
        guiGraphics.pose().popMatrix();
        if (((BookImagePage)this.page).hasBorder()) {
            BookContentRenderer.drawFromContentTexture(RenderPipelines.GUI_TEXTURED, guiGraphics, ((BookImagePage)this.getPage()).getBook(), x, y, 405, 149, 106, 106);
        }
        if (((BookImagePage)this.page).getImages().length > 1 && ((BookImagePage)this.page).hasBorder()) {
            int xs = x + 83;
            int ys = y + 92;
            guiGraphics.fill(xs, ys, xs + 20, ys + 11, 0x44000000);
            guiGraphics.fill(xs - 1, ys - 1, xs + 20, ys + 11, 0x44000000);
        }
        if ((style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style titleStyle;
            if (((BookImagePage)this.page).hasTitle() && (titleStyle = this.getClickedComponentStyleAtForTitle(((BookImagePage)this.page).getTitle(), 62, 0, pMouseX, pMouseY)) != null) {
                return titleStyle;
            }
            int textY = this.getTextY();
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookImagePage)this.page).getText(), 0, textY, 124, 155 - textY, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }

    @Override
    public int getTextY() {
        return 115;
    }
}

