/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.button.VisualizeButton;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BookMultiblockPageRenderer
extends BookPageRenderer<BookMultiblockPage>
implements PageWithTextRenderer {
    private static final RandomSource randomSource = RandomSource.createNewThreadLocalInstance();
    private final Map<BlockPos, BlockEntity> blockEntityCache = new Object2ObjectOpenHashMap();
    private final Set<BlockEntity> erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
    protected Pair<BlockPos, Collection<Multiblock.SimulateResult>> multiblockSimulation;
    protected Button visualizeButton;

    public BookMultiblockPageRenderer(BookMultiblockPage page) {
        super(page);
    }

    public void handleButtonVisualize(Button button) {
        MultiblockPreviewRenderer.setMultiblock(((BookMultiblockPage)this.page).getMultiblock(), ((BookMultiblockPage)this.page).getMultiblockName().getComponent(), true);
        BookGuiManager.get().closeScreenStack(this.parentScreen);
    }

    private void renderMultiblock(GuiGraphics guiGraphics) {
    }

    private void renderBlock(MultiBufferSource.BufferSource buffers, ClientLevel level, BlockState state, BlockPos pos, float alpha, PoseStack ps) {
        if (pos != null) {
            ps.pushPose();
            ps.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            ClientServices.MULTIBLOCK.renderBlock(state, pos, ((BookMultiblockPage)this.page).getMultiblock(), ps, (MultiBufferSource)buffers, randomSource);
            ps.popPose();
        }
    }

    @Override
    public int getTextY() {
        return 115;
    }

    @Override
    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.multiblockSimulation = ((BookMultiblockPage)this.page).getMultiblock().simulate(null, BlockPos.ZERO, Rotation.NONE, true, true);
        if (((BookMultiblockPage)this.page).showVisualizeButton()) {
            this.visualizeButton = new VisualizeButton(this.parentScreen, 13, 102, this::handleButtonVisualize);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        int x = 9;
        int y = 7;
        BookContentRenderer.drawFromContentTexture(RenderPipelines.GUI_TEXTURED, guiGraphics, ((BookMultiblockPage)this.page).getBook(), x, y, 405, 149, 106, 106);
        if (!((BookMultiblockPage)this.page).getMultiblockName().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookMultiblockPage)this.page).getMultiblockName(), false, 62, 0);
        }
        this.renderMultiblock(guiGraphics);
        int textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, ((BookMultiblockPage)this.page).getText(), 0, textY, 124, 155 - textY);
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style multiblockNameStyle = this.getClickedComponentStyleAtForTitle(((BookMultiblockPage)this.page).getMultiblockName(), 62, 0, pMouseX, pMouseY);
            if (multiblockNameStyle != null) {
                return multiblockNameStyle;
            }
            int x = this.parentScreen.getBook().getBookTextOffsetX();
            int y = this.getTextY() + this.parentScreen.getBook().getBookTextOffsetY();
            int width = 124 + this.parentScreen.getBook().getBookTextOffsetWidth() - x;
            int height = 155 + this.parentScreen.getBook().getBookTextOffsetHeight() - y;
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookMultiblockPage)this.page).getText(), x, y, width, height, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }
}

