/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.item;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.registry.DataComponentRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ModonomiconItem
extends Item {
    public ModonomiconItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static Book getBook(ItemStack stack) {
        ResourceLocation res = ModonomiconItem.getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookDataManager.get().getBook(res);
    }

    public static ResourceLocation getBookId(ItemStack stack) {
        return (ResourceLocation)stack.get(DataComponentRegistry.BOOK_ID.get());
    }

    public static void setBookClosed(ItemStack stack) {
        if (stack != null) {
            stack.set(DataComponentRegistry.BOOK_OPEN.get(), (Object)false);
        }
    }

    public static boolean isBookOpen(ItemStack stack) {
        if (stack != null && stack.has(DataComponentRegistry.BOOK_OPEN.get())) {
            Boolean val = (Boolean)stack.get(DataComponentRegistry.BOOK_OPEN.get());
            return Boolean.TRUE.equals(val);
        }
        return false;
    }

    public Book getBookFor(ItemStack stack) {
        return ModonomiconItem.getBook(stack);
    }

    @NotNull
    public InteractionResult use(Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.getItemInHand(pUsedHand);
        itemInHand.set(DataComponentRegistry.BOOK_OPEN.get(), (Object)true);
        if (pLevel.isClientSide()) {
            if (itemInHand.get(DataComponentRegistry.BOOK_ID.get()) != null) {
                Book book = ModonomiconItem.getBook(itemInHand);
                BookGuiManager.get().openBook(BookAddress.defaultFor(book));
            } else {
                Modonomicon.LOG.error("ModonomiconItem: ItemStack has no tag!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Component getName(ItemStack pStack) {
        Book book = this.getBookFor(pStack);
        if (book != null) {
            return Component.translatable((String)book.getName());
        }
        return super.getName(pStack);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, @NotNull TooltipDisplay tooltipDisplay, @NotNull Consumer<Component> consumer, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        Book book = ModonomiconItem.getBook(itemStack);
        if (book != null) {
            if (tooltipFlag.isAdvanced()) {
                consumer.accept((Component)Component.literal((String)"Book ID: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)book.getId().toString()).withStyle(ChatFormatting.RED)));
            }
            if (!book.getTooltip().isBlank()) {
                consumer.accept((Component)Component.translatable((String)book.getTooltip()).withStyle(ChatFormatting.GRAY));
            }
        } else {
            CompoundTag compound = new CompoundTag();
            for (TypedDataComponent entry : itemStack.getComponents()) {
                Tag tag = (Tag)entry.encodeValue((DynamicOps)NbtOps.INSTANCE).getOrThrow();
                ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)entry.type());
                compound.put(key.toString(), tag);
            }
            consumer.accept((Component)Component.translatable((String)"tooltip.modonomicon.no_book_found_for_stack", (Object[])new Object[]{NbtUtils.toPrettyComponent((Tag)compound)}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

