/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book;

import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

public class BookTextHolder {

    public static final BookTextHolder EMPTY = new BookTextHolder("");

    private class_2561 component;
    private String string;

    protected BookTextHolder() {
    }

    public BookTextHolder(class_2561 component) {
        this.component = component;
    }

    public BookTextHolder(@NotNull String string) {
        this.string = string;
    }

    public static BookTextHolder fromNetwork(class_9129 buffer) {
        if (buffer.readBoolean()) {
            return new BookTextHolder(class_8824.field_48540.decode(buffer));
        } else {
            return new BookTextHolder(buffer.method_19772());
        }
    }

    public String getString() {
        return this.hasComponent() ? this.component.getString() : class_1074.method_4662(this.string);
    }

    /**
     * Gets the translation key, or null if none
     */
    public String getKey() {
        if (this.hasComponent() && this.component.method_10851() instanceof class_2588 contents) {
            return contents.method_11022();
        }
        return this.string;
    }

    public class_2561 getComponent() {
        return this.component;
    }

    public boolean hasComponent() {
        return this.component != null;
    }

    public boolean isEmpty() {
        //Note: BookTextHolder needs to override this, because string will always be null for it
        return (this.hasComponent() ? this.component.getString() : this.string).isEmpty();
    }

    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.hasComponent());
        if (this.hasComponent()) {
            class_8824.field_48540.encode(buffer, this.component);
        } else {
            buffer.method_10814(this.string);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        var that = (BookTextHolder) o;

        if (this.hasComponent() && that.hasComponent()) {
            return this.component.equals(that.component);
        }

        if (this.string != null)
            return this.string.equals(that.string);

        return false;
    }

    @Override
    public int hashCode() {
        return this.hasComponent() ? this.component.hashCode() :  this.string == null ? 0 : this.string.hashCode();
    }

    public record ScaleCacheKey(BookTextHolder holder, int width, int height){

    }
}
