/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Gui;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.error.BookErrorHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorInfo;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5481;

public class BookErrorScreen extends class_437 {

    public static final int BOOK_BACKGROUND_WIDTH = 272;
    public static final int BOOK_BACKGROUND_HEIGHT = 178;
    private static final class_2960 BOOK_CONTENT_TEXTURE = class_2960.method_60655(Modonomicon.MOD_ID, "textures/gui/book_content.png");
    private final Book book;
    private int bookLeft;
    private int bookTop;
    private class_2561 errorText;

    public BookErrorScreen(Book book) {
        super(class_2561.method_43470(""));

        this.book = book;

        this.field_22787 = class_310.method_1551();
    }

    public void renderBookBackground(class_332 guiGraphics) {
        int x = 0;
        int y = 0;

        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        guiGraphics.method_25290(BOOK_CONTENT_TEXTURE, x, y, 0, 0, 272, 178, 512, 256);
    }

    public void renderError(class_332 guiGraphics, class_2561 text, int x, int y, int width) {
        for (class_5481 formattedcharsequence : this.field_22793.method_1728(text, width)) {
            guiGraphics.method_51430(this.field_22793, formattedcharsequence, x, y, 0, false);
            y += this.field_22793.field_2000;
        }
    }

    public void prepareError() {
        var errorHolder = BookErrorManager.get().getErrors(this.book.getId());
        if (errorHolder.getErrors().isEmpty()) {
            this.errorText = class_2561.method_43471(Gui.NO_ERRORS_FOUND);
            Modonomicon.LOG.warn("No errors found for book {}, but error screen was opened!", this.book.getId());
        } else {
            var firstError = errorHolder.getErrors().get(0);

            var errorString = firstError.toString();
            if (errorHolder.getErrors().size() > 1) {
                errorString += "\n\n(" + (errorHolder.getErrors().size() - 1) + " more errors, see log)";
            }
            this.errorText = class_2561.method_43470(errorString);
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {

        this.method_25420(guiGraphics, pMouseX, pMouseY, pPartialTick);

        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.bookLeft, this.bookTop, 0);
        this.renderBookBackground(guiGraphics);
        guiGraphics.method_51448().method_22909();

        //do not translate super (= widget rendering) -> otherwise our buttons are messed up
        //manually call the renderables like super does -> otherwise super renders the background again on top of our stuff
        for (var renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }

        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.bookLeft, this.bookTop, 0);
        this.renderError(guiGraphics, this.errorText, 15, 15, BOOK_BACKGROUND_WIDTH - 30);
        guiGraphics.method_51448().method_22909();
    }

    @Override
    public boolean method_25422() {
        return true;
    }


    @Override
    protected void method_25426() {
        super.method_25426();

        this.bookLeft = (this.field_22789 - BOOK_BACKGROUND_WIDTH) / 2;
        this.bookTop = (this.field_22790 - BOOK_BACKGROUND_HEIGHT) / 2;

        this.prepareError();

    }

    @Override
    public boolean method_25421() {
        return false;
    }
}
