/*
 *
 *  * SPDX-FileCopyrightText: 2022 klikli-dev
 *  *
 *  * SPDX-License-Identifier: MIT
 *
 */

package com.klikli_dev.modonomicon.api.datagen.book.condition;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Condition;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

public class BookCategoryHasVisibleEntriesConditionModel extends BookConditionModel<BookCategoryHasVisibleEntriesConditionModel> {
    private class_2960 categoryId;

    protected BookCategoryHasVisibleEntriesConditionModel() {
        super(Condition.CATEGORY_HAS_VISIBLE_ENTRIES);
    }

    public static BookCategoryHasVisibleEntriesConditionModel create() {
        return new BookCategoryHasVisibleEntriesConditionModel();
    }


    @Override
    public JsonObject toJson(class_2960 conditionParentId, class_7225.class_7874 provider) {
        var json = super.toJson(conditionParentId, provider);

        if (this.categoryId.method_12836().equals(conditionParentId.method_12836()))
            json.addProperty("category_id", this.categoryId.method_12832());
        else
            json.addProperty("category_id", this.categoryId.toString());

        return json;
    }

    public class_2960 getCategoryId() {
        return this.categoryId;
    }


    public BookCategoryHasVisibleEntriesConditionModel withCategory(class_2960 entryId) {
        this.categoryId = entryId;
        return this;
    }


    public BookCategoryHasVisibleEntriesConditionModel withCategory(String entryId) {
        this.categoryId = class_2960.method_60654(entryId);
        return this;
    }

    @Override
    public BookCategoryHasVisibleEntriesConditionModel withTooltip(class_2561 tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    /**
     * Will overwrite withTooltip
     */
    @Override
    public BookCategoryHasVisibleEntriesConditionModel withTooltipString(String tooltipString) {
        this.tooltipString = tooltipString;
        return this;
    }
}
