// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.api.events;

import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.client.gui.book.entry.EntryDisplayState;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

/**
 * An event that is fired on both the client and server side, when an entry is read for the first time.
 * Note that resetting the book and then reading the entry again, will trigger this event again.
 *
 * If you are e.g. awarding rewards based on this event you should save somewhere that the player already received the entry.
 * See e.g. {@link BookCommand#execute(class_3222)} which stores how many times a command has been executed.
 *
 * Further, any rewards or persistent game logic should only be done on the server side call of this event.
 */
public class EntryFirstReadEvent extends ModonomiconEvent {
    protected class_2960 bookId;
    protected class_2960 entryId;

    public EntryFirstReadEvent(class_2960 bookId, class_2960 entryId) {
        super(false);

        this.bookId = bookId;
        this.entryId = entryId;
    }

    public class_2960 getBookId() {
        return this.bookId;
    }

    public class_2960 getEntryId() {
        return this.entryId;
    }
}
