/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Condition;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Tooltips;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.RequestAdvancementMessage;
import com.klikli_dev.modonomicon.platform.Services;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public class BookAdvancementCondition extends BookCondition {

    protected class_2960 advancementId;

    public BookAdvancementCondition(class_2561 component, class_2960 advancementId) {
        super(component);
        this.advancementId = advancementId;
    }

    public static BookAdvancementCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        var advancementId = class_2960.method_60654(class_3518.method_15265(json, "advancement_id"));


        //default tooltip is null because we construct it on the fly from the advancement id
        class_2561 tooltip = null;

        if (json.has("tooltip")) {
            tooltip = tooltipFromJson(json, provider);
        }

        return new BookAdvancementCondition(tooltip, advancementId);
    }

    public static BookAdvancementCondition fromNetwork(class_9129 buffer) {
        var tooltip = buffer.readBoolean() ? class_8824.field_48540.decode(buffer) : null;
        var advancementId = buffer.method_10810();
        return new BookAdvancementCondition(tooltip, advancementId);
    }

    @Override
    public class_2960 getType() {
        return Condition.ADVANCEMENT;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.tooltip != null);
        if (this.tooltip != null) {
            class_8824.field_48540.encode(buffer, this.tooltip);
        }
        buffer.method_10812(this.advancementId);
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        if (player instanceof class_3222 serverPlayer) {
            var advancement = serverPlayer.method_5682().method_3851().method_12896(this.advancementId);
            return advancement != null && serverPlayer.method_14236().method_12882(advancement).method_740();
        }
        return false;
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltip != null) {
            return List.of(this.tooltip);
        }

        var tooltip = class_2561.method_43469(Tooltips.CONDITION_ADVANCEMENT, DistHelper.getAdvancementTitle(player, this.advancementId));

        return List.of(tooltip);
    }

    public static class DistHelper {
        public static long lastRequestTime = 0;
        public static class_2561 getAdvancementTitle(class_1657 player, class_2960 advancementId) {
            if (player instanceof class_746 localPlayer) {
                //Problem: Advancements are not synced to the client by vanilla if they are visible - and actively removed if they are not.
                var adv = localPlayer.field_3944.method_2869().method_53815(advancementId);

                //if not known by the player, check our local cache
                if (adv == null)
                    adv = BookDataManager.Client.get().getAdvancement(advancementId);


                //if not available locally, request from server for our local cache
                if (adv == null) {
                    //only request every second
                    if (System.currentTimeMillis() - lastRequestTime > 1000) {
                        lastRequestTime = System.currentTimeMillis();
                        Services.NETWORK.sendToServer(new RequestAdvancementMessage(advancementId));
                    }
                    return class_2561.method_43471(Tooltips.CONDITION_ADVANCEMENT_LOADING);
                }

                if (!adv.comp_1920().comp_1913().isPresent()) //if advancement has no display we cannot show anything
                    return class_2561.method_43471(Tooltips.CONDITION_ADVANCEMENT_HIDDEN);

                return adv.comp_1920().comp_1913().get().method_811();
            }

            return class_2561.method_43470("Unknown"); //this should never happen -> player always must be local player
        }
    }
}
