/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.data.BookConditionJsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public abstract class BookCondition {

    protected class_2561 tooltip;

    public BookCondition(class_2561 tooltip) {
        this.tooltip = tooltip;
    }

    public static class_5250 tooltipFromJson(JsonObject json, class_7225.class_7874 provider) {
        if (json.has("tooltip")) {
            var tooltipElement = json.get("tooltip");
            if (tooltipElement.isJsonPrimitive())
                return class_2561.method_43471(tooltipElement.getAsString());

            class_2561.method_43470("").method_10852(class_8824.field_46597.parse(provider.method_57093(JsonOps.INSTANCE), tooltipElement).getOrThrow());
        }
        return null;
    }

    public static BookCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        var type = class_2960.method_60654(class_3518.method_15265(json, "type"));
        var loader = LoaderRegistry.getConditionJsonLoader(type);
        return loader.fromJson(conditionParentId, json, provider);
    }

    public static BookCondition fromNetwork(class_9129 buf) {
        var type = buf.method_10810();
        var loader = LoaderRegistry.getConditionNetworkLoader(type);
        return loader.fromNetwork(buf);
    }

    public static void toNetwork(BookCondition condition, class_9129 buf) {
        buf.method_10812(condition.getType());
        condition.toNetwork(buf);
    }

    public abstract class_2960 getType();

    /**
     * Always write type before calling, ideally call {@link #toNetwork(BookCondition, class_9129)}
     */
    public abstract void toNetwork(class_9129 buffer);

    /**
     * Use this to test the condition for the given player at runtime
     */
    public abstract boolean test(BookConditionContext context, class_1657 player);

    /**
     * Use this to test the condition at load time.
     * If this returns false, the locked content will not be loaded at all.
     * Most conditions should not override this - it was added primarily for the ModLoadedCondition, because
     * content locked behind it may not be present at all if the condition is false and loading would cause errors.
     */
    public boolean testOnLoad() {
        return true;
    }

    /**
     * If true then this condition needs to be tested multiple times during BookUnlockStates#update
     * This should be true if the condition depends on ANOTHER unlock condition.
     * Usually that is the case for BookEntryUnlockedCondition, BookAndCondition and BookOrCondition.
     * The latter two because they may contain the former.
     */
    public boolean requiresMultiPassUnlockTest() {
        return false;
    }

    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        return this.tooltip != null ? List.of(this.tooltip) : List.of();
    }
}
