/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Condition;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Tooltips;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public class BookEntryReadCondition extends BookCondition {

    protected class_2960 entryId;

    public BookEntryReadCondition(class_2561 tooltip, class_2960 entryId) {
        super(tooltip);
        this.entryId = entryId;
    }

    public static BookEntryReadCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        var entryPath = class_3518.method_15265(json, "entry_id");
        var entryId = entryPath.contains(":") ?
                class_2960.method_60654(entryPath) :
                class_2960.method_60655(conditionParentId.method_12836(), entryPath);

        var tooltip = tooltipFromJson(json, provider);

        return new BookEntryReadCondition(tooltip, entryId);
    }

    public static BookEntryReadCondition fromNetwork(class_9129 buffer) {
        var tooltip = buffer.readBoolean() ? class_8824.field_48540.decode(buffer) : null;
        var entryId = buffer.method_10810();
        return new BookEntryReadCondition(tooltip, entryId);
    }

    @Override
    public class_2960 getType() {
        return Condition.ENTRY_READ;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.tooltip != null);
        if (this.tooltip != null) {
            class_8824.field_48540.encode(buffer, this.tooltip);
        }
        buffer.method_10812(this.entryId);
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        var entry = context.getBook().getEntry(this.entryId);
        if (entry == null) {
            throw new IllegalArgumentException("Entry with id " + this.entryId + " not found in book " + context.getBook().getId() + "for BookEntryReadCondition. This happened while trying to unlock " + context);
        }
        return BookUnlockStateManager.get().isReadFor(player, entry);
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext entryContext) {
            this.tooltip = class_2561.method_43469(Tooltips.CONDITION_ENTRY_READ, class_2561.method_43471(entryContext.getBook().getEntry(this.entryId).getName()));
        }
        return super.getTooltip(player, context);
    }
}
