/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class CategoryLinkBookEntry extends BookEntry {

    /**
     * The category to open on click
     */
    protected class_2960 categoryToOpenId;
    protected BookCategory categoryToOpen;

    public CategoryLinkBookEntry(class_2960 id, BookEntryData data, class_2960 commandToRunOnFirstReadId, class_2960 categoryToOpenId) {
        super(id, data, commandToRunOnFirstReadId);
        this.categoryToOpenId = categoryToOpenId;
    }

    public static CategoryLinkBookEntry fromJson(class_2960 id, JsonObject json, boolean autoAddReadConditions, class_7225.class_7874 provider) {
        BookEntryData data = BookEntryData.fromJson(id, json, autoAddReadConditions, provider);

        class_2960 commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = class_2960.method_60654(class_3518.method_15265(json, "command_to_run_on_first_read"));
        }

        var categoryToOpenIdPath = class_3518.method_15265(json, "category_to_open");
        var categoryToOpenId = categoryToOpenIdPath.contains(":") ?
                class_2960.method_60654(categoryToOpenIdPath) :
                class_2960.method_60655(id.method_12836(), categoryToOpenIdPath);

        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpenId);
    }

    public static CategoryLinkBookEntry fromNetwork(class_9129 buffer) {
        var id = buffer.method_10810();
        BookEntryData data = BookEntryData.fromNetwork(buffer);
        class_2960 commandToRunOnFirstReadId = buffer.method_43827(class_2540::method_10810);
        class_2960 categoryToOpen = buffer.method_43827(class_2540::method_10810); //can be set to null in #build, if the category was not found

        return new CategoryLinkBookEntry(id, data, commandToRunOnFirstReadId, categoryToOpen);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.EntryType.CATEGORY_LINK;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_10812(this.id);
        this.data.toNetwork(buffer);
        buffer.method_43826(this.commandToRunOnFirstReadId, class_2540::method_10812);
        buffer.method_43826(this.categoryToOpenId, class_2540::method_10812); //can be set to null in #build, if the category was not found
    }

    @Override
    public void build(class_1937 level, BookCategory category) {
        super.build(level, category);

        if (this.categoryToOpenId != null) {
            this.categoryToOpen = this.getBook().getCategory(this.categoryToOpenId);

            if (this.categoryToOpen == null) {
                BookErrorManager.get().error("Category to open \"" + this.categoryToOpenId + "\" does not exist in this book. Set to null.");
                this.categoryToOpenId = null;
            }
        }
    }

    public BookCategory getCategoryToOpen() {
        return this.categoryToOpen;
    }

    @Override
    public void openEntry(BookAddress address) {
        //if we jump to a category, we push the current category to history to be able to return
        BookGuiManager.get().pushHistory(BookAddress.defaultFor(this.getCategory()));
        //we don't have any use for the address here
        BookGuiManager.get().openCategoryLinkEntry(this);
    }

}
