/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class EntryLinkBookEntry extends BookEntry {

    /**
     * The entry to open on click
     */
    protected class_2960 entryToOpenId;
    protected BookEntry entryToOpen;

    public EntryLinkBookEntry(class_2960 id, BookEntryData data, class_2960 commandToRunOnFirstReadId, class_2960 entryToOpenId) {
        super(id, data, commandToRunOnFirstReadId);
        this.entryToOpenId = entryToOpenId;
    }

    public static EntryLinkBookEntry fromJson(class_2960 id, JsonObject json, boolean autoAddReadConditions, class_7225.class_7874 provider) {
        BookEntryData data = BookEntryData.fromJson(id, json, autoAddReadConditions, provider);

        class_2960 commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            commandToRunOnFirstReadId = class_2960.method_60654(class_3518.method_15265(json, "command_to_run_on_first_read"));
        }

        var entryToOpenIdPath = class_3518.method_15265(json, "entry_to_open");
        var entryToOpenId = entryToOpenIdPath.contains(":") ?
                class_2960.method_60654(entryToOpenIdPath) :
                class_2960.method_60655(id.method_12836(), entryToOpenIdPath);

        return new EntryLinkBookEntry(id, data, commandToRunOnFirstReadId, entryToOpenId);
    }

    public static EntryLinkBookEntry fromNetwork(class_9129 buffer) {
        var id = buffer.method_10810();
        BookEntryData data = BookEntryData.fromNetwork(buffer);
        class_2960 commandToRunOnFirstReadId = buffer.method_43827(class_2540::method_10810);
        class_2960 entryToOpen = buffer.method_10810();

        return new EntryLinkBookEntry(id, data, commandToRunOnFirstReadId, entryToOpen);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.EntryType.ENTRY_LINK;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_10812(this.id);
        this.data.toNetwork(buffer);
        buffer.method_43826(this.commandToRunOnFirstReadId, class_2540::method_10812);
        buffer.method_10812(this.entryToOpenId);
    }

    @Override
    public void build(class_1937 level, BookCategory entry) {
        super.build(level, entry);

        if (this.entryToOpenId != null) {
            this.entryToOpen = this.getBook().getEntry(this.entryToOpenId);

            if (this.entryToOpen == null) {
                BookErrorManager.get().error("Entry to open \"" + this.entryToOpenId + "\" does not exist in this book. Set to null.");
                this.entryToOpenId = null;
            }
        }
    }

    public BookEntry getEntryToOpen() {
        return this.entryToOpen;
    }

    @Override
    public void openEntry(BookAddress address) {
        //if we jump to an entry, we push the current category to history to be able to return
        BookGuiManager.get().pushHistory(BookAddress.defaultFor(this.getCategory()));

        BookGuiManager.get().openEntry(this.entryToOpen, BookAddress.defaultFor(this.entryToOpen));
    }

}
