/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 * SPDX-FileCopyrightText: 2021 Authors of Patchouli
 *
 * SPDX-License-Identifier: MIT
 */


package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Gui;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class EntryListButton extends class_4185 {

    private static final int ANIM_TIME = 5;

    private final BookEntry entry;
    private final @Nullable BookAddress addressToOpen;
    private float timeHovered;

    public EntryListButton(BookEntry entry, int pX, int pY, class_4241 pOnPress) {
        this(entry, null, pX, pY, pOnPress);
    }

    public EntryListButton(BookEntry entry, @Nullable BookAddress addressToOpen, int pX, int pY, class_4241 pOnPress) {
        super(pX, pY, BookEntryScreen.PAGE_WIDTH, 10, class_2561.method_43471(entry.getName()), pOnPress, class_4185.field_40754);

        this.entry = entry;
        this.addressToOpen = addressToOpen;
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    public @Nullable BookAddress getAddressToOpen() {
        return this.addressToOpen;
    }

    private int getEntryColor() {
        return 0xFF000000;
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22763) {
            if (this.method_49606()) {
                this.timeHovered = Math.min(ANIM_TIME, this.timeHovered + ClientTicks.delta);
            } else {
                this.timeHovered = Math.max(0, this.timeHovered - ClientTicks.delta);
            }

            float time = Math.max(0, Math.min(ANIM_TIME, this.timeHovered + (this.method_49606() ? partialTicks : -partialTicks)));
            float widthFract = time / ANIM_TIME;
            boolean locked = !BookUnlockStateManager.get().isUnlockedFor(class_310.method_1551().field_1724, this.entry);

            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().scale(0.5F, 0.5F);
            guiGraphics.method_25294(this.method_46426() * 2, this.method_46427() * 2, (this.method_46426() + (int) ((float) this.field_22758 * widthFract)) * 2, (this.method_46427() + this.field_22759) * 2, 0x22000000);

            if (locked) {
                var color = class_9848.method_61318(0.7f, 1f, 1f,1f);
                BookContentRenderer.drawLock(guiGraphics, this.entry.getBook(), this.method_46426() * 2 + 2, this.method_46427() * 2 + 2, color);
            } else {
                this.entry.getIcon().render(guiGraphics, this.method_46426() * 2 + 2, this.method_46427() * 2 + 2);
            }

            guiGraphics.method_51448().scale(2F, 2F);
            guiGraphics.method_51448().popMatrix();

            class_5250 name;
            if (locked) {
                name = class_2561.method_43471(Gui.SEARCH_ENTRY_LOCKED);
            } else {
                name = class_2561.method_43471(this.entry.getName());
            }

            //apply the custom book font
            name.method_27694(style -> style.method_27704(BookDataManager.Client.get().safeFont(this.entry.getBook().getFont())));

            int x = this.method_46426() + 12; //shift right to make space for the icon
            int y = this.method_46427() + 2;
            int maxWidth = BookEntryScreen.PAGE_WIDTH - 12; //make space for the icon and margin

            guiGraphics.method_51448().pushMatrix();

            var scale = Math.min(1.0f, (float) maxWidth / (float) class_310.method_1551().field_1772.method_27525(name));
            if (scale < 1) {
                guiGraphics.method_51448().translate(x - x * scale, y - y * scale);
                guiGraphics.method_51448().scale(scale, scale);
            }
            guiGraphics.method_51439(class_310.method_1551().field_1772, name, x, y, this.getEntryColor(), false);

            guiGraphics.method_51448().popMatrix();
        }
    }

    @Override
    public void method_25354(class_1144 soundHandlerIn) {
        if (this.entry != null) {
            //TODO: play flip sound
        }
    }
}
