/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class SearchButton extends class_4185 {

    private final BookParentScreen parent;
    private final int scissorX;

    public SearchButton(BookParentScreen parent, int pX, int pY, int scissorX, int width, int height, class_4241 pOnPress, class_7919 tooltip) {
        super(pX, pY, width, height, class_2561.method_43470(""), pOnPress, class_4185.field_40754);
        this.method_47400(tooltip);
        this.scissorX = scissorX;
        this.parent = parent;
    }

    @Override
    public void method_48579(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.field_22764) {
            guiGraphics.method_51448().pushMatrix();
            int xOffset = this.parent.getBook().getSearchButtonXOffset();
            guiGraphics.method_51448().translate(xOffset, 0);

            int scissorX = this.scissorX + xOffset;
            int texX = 15;
            int texY = 165;

            int renderX = this.method_46426();
            int scissorWidth = this.field_22758 + (this.method_46426() - this.scissorX);
            int scissorY = (((class_437) this.parent).field_22790 - this.method_46427() - this.field_22759 - 1); //from the bottom up

            if (this.method_49606()) {
                renderX += 1;
                scissorWidth -= 1;
            }

            //as of 1.20 this causes the button to vanish behind the rendered world, so we don't use it
            //guiGraphics.pose().translate(xOffset, 0, -1000);

            //GL scissors allows us to move the button on hover without intersecting with book border
            guiGraphics.method_44379(scissorX, scissorY, scissorX + scissorWidth, scissorY + 1000);

            guiGraphics.method_25290(class_10799.field_56883, this.parent.getBook().getBookOverviewTexture(), renderX, this.method_46427(), texX, texY, this.field_22758, this.field_22759, 256, 256);

            guiGraphics.method_44380();
            guiGraphics.method_51448().popMatrix();
        }
    }
}
