/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Gui;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import org.commonmark.node.Link;
import org.commonmark.node.Node;

import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;

public class BookLinkRenderer implements LinkRenderer {
    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {
        if (BookLink.isBookLink(link.getDestination())) {
            var currentColor = context.getCurrentStyle().method_10973();

            BookErrorManager.get().setContext("Link: {}, \n{}",
                    link.getDestination(),
                    BookErrorManager.get().getContextHelper()
            );

            try {
                var bookLink = BookLink.from(context.getBook(), link.getDestination());
                var book = BookDataManager.get().getBook(bookLink.bookId);
                var goToText = class_2561.method_43471(book.getName());
                if (bookLink.categoryId != null) {
                    var category = book.getCategory(bookLink.categoryId);
                    goToText = class_2561.method_43471(category.getName());
                }
                if (bookLink.entryId != null) {
                    var entry = book.getEntry(bookLink.entryId);
                    goToText = class_2561.method_43471(entry.getName());
                }
                //Note: if we ever change this we need to adjust renderComponentHoverEffect
                var hoverComponent = class_2561.method_43469(Gui.HOVER_BOOK_LINK, goToText);


                //if we have a color we use it, otherwise we use link default.
                context.setCurrentStyle(context.getCurrentStyle()
                        .method_27703(currentColor == null ? context.getLinkColor() : currentColor)
                        .method_10958(new class_2558.class_10607(link.getDestination()))
                        .method_10949(new class_2568.class_10613(hoverComponent))
                );

                visitChildren.accept(link);

                //links are not style instructions, so we reset to our previous color.
                context.setCurrentStyle(context.getCurrentStyle()
                        .method_27703(currentColor)
                        .method_10958(null)
                        .method_10949(null)
                );
            } catch (Exception e) {
                if (context.getBook().allowOpenBooksWithInvalidLinks()) {
                    Modonomicon.LOG.error("Failed to parse book link. allowOpenBooksWithInvalidLinks = true, so book parsing continues. Original error:", e);

                    //Render error message as tooltip in red
                    var hoverComponent = class_2561.method_43469(Gui.HOVER_BOOK_LINK_ERROR, link.getDestination()).method_27692(class_124.field_1061);

                    //Render link in red
                    context.setCurrentStyle(context.getCurrentStyle()
                            .method_10977(class_124.field_1061)
                            .method_10949(new class_2568.class_10613(hoverComponent))
                    );

                    visitChildren.accept(link);

                    //links are not style instructions, so we reset to our previous color.
                    context.setCurrentStyle(context.getCurrentStyle()
                            .method_27703(currentColor)
                            .method_10958(null)
                            .method_10949(null)
                    );
                } else {
                    throw e;
                }
            }

            BookErrorManager.get().setContext(null);
            return true;
        }
        return false;

    }
}
