/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.book.page.BookSmithingRecipePage;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10297;
import net.minecraft.class_10314;
import net.minecraft.class_10363;
import net.minecraft.class_10799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8059;

public class BookSmithingRecipePageRenderer extends BookRecipePageRenderer<class_8059, BookSmithingRecipePage> {
    public BookSmithingRecipePageRenderer(BookSmithingRecipePage page) {
        super(page);
    }

    @Override
    protected int getRecipeHeight() {
        return 76;
    }

    @Override
    protected void drawRecipe(class_332 guiGraphics, class_10297 recipeDisplayEntry, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {

        recipeY += 10;


        if (!second) {
            if (!this.page.getTitle1().isEmpty()) {
                this.renderTitle(guiGraphics, this.page.getTitle1(), false, BookEntryScreen.PAGE_WIDTH / 2, 0);
            }
        } else {
            if (!this.page.getTitle2().isEmpty()) {
                this.renderTitle(guiGraphics, this.page.getTitle2(), false, BookEntryScreen.PAGE_WIDTH / 2,
                        recipeY - (this.page.getTitle2().getString().isEmpty() ? 10 : 0) - 10);
            }
        }

        guiGraphics.method_25290(class_10799.field_56883, this.page.getBook().getCraftingTexture(), recipeX, recipeY, 11, 178, 96, 62, 128, 256);

        if (recipeDisplayEntry.comp_3263() instanceof class_10314 smithingRecipeDisplay) {
            //noinspection DataFlowIssue
            var context = class_10363.method_65008(class_310.method_1551().field_1687);
            this.parentScreen.renderItemStacks(guiGraphics, recipeX + 4, recipeY + 4, mouseX, mouseY, smithingRecipeDisplay.comp_3302().method_64738(context));
            this.parentScreen.renderItemStacks(guiGraphics, recipeX + 4, recipeY + 23, mouseX, mouseY, smithingRecipeDisplay.comp_3303().method_64738(context));
            this.parentScreen.renderItemStacks(guiGraphics, recipeX + 4, recipeY + 42, mouseX, mouseY, smithingRecipeDisplay.comp_3304().method_64738(context));
            this.parentScreen.renderItemStacks(guiGraphics, recipeX + 40, recipeY + 23, mouseX, mouseY, smithingRecipeDisplay.comp_3259().method_64738(context));
            this.parentScreen.renderItemStacks(guiGraphics, recipeX + 76, recipeY + 23, mouseX, mouseY, smithingRecipeDisplay.comp_3258().method_64738(context));
        }
    }
}
