/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.command;

import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Command;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;

public class ResetBookUnlocksCommand implements com.mojang.brigadier.Command<class_2168> {

    public static final DynamicCommandExceptionType ERROR_UNKNOWN_BOOK = new DynamicCommandExceptionType((message) -> {
        return class_2561.method_43469(Command.ERROR_UNKNOWN_BOOK, message);
    });

    public static final SuggestionProvider<class_2168> SUGGEST_BOOK = (context, builder) -> {
        var books = BookUnlockStateManager.get().getBooksFor(context.getSource().method_44023());
        return class_2172.method_9270(books, builder);
    };
    private static final ResetBookUnlocksCommand CMD = new ResetBookUnlocksCommand();


    public static ArgumentBuilder<class_2168, ?> register(CommandDispatcher<class_2168> dispatcher) {
        return class_2170.method_9247("reset")
                .requires(cs -> cs.method_9259(1))
                .then(class_2170.method_9244("book", class_2232.method_9441())
                        .suggests(SUGGEST_BOOK)
                        .executes(CMD));

    }


    public static Book getBook(CommandContext<class_2168> pContext, String pName) throws CommandSyntaxException {
        var resourcelocation = class_2232.method_9443(pContext, pName);
        var book = BookDataManager.get().getBook(resourcelocation);
        if (book == null) {
            throw ERROR_UNKNOWN_BOOK.create(resourcelocation);
        } else {
            return book;
        }
    }

    @Override
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        var book = getBook(context, "book");
        BookUnlockStateManager.get().resetFor(context.getSource().method_44023(), book);
        BookUnlockStateManager.get().updateAndSyncFor(context.getSource().method_44023());
        context.getSource().method_9226(() -> class_2561.method_43469(Command.SUCCESS_RESET_BOOK, class_2561.method_43471(book.getName())), true);
        return 1;
    }
}
