package com.klikli_dev.modonomicon.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

/**
 * Copied from 1.21.1
 */
public abstract class LegacySimpleJsonResourceReloadListener extends class_4080<Map<class_2960, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson gson;
    private final String directory;

    public LegacySimpleJsonResourceReloadListener(Gson gson, String directory) {
        this.gson = gson;
        this.directory = directory;
    }

    /**
     * Performs any reloading that can be done off-thread, such as file IO
     */
    protected Map<class_2960, JsonElement> method_18789(class_3300 resourceManager, class_3695 profiler) {
        Map<class_2960, JsonElement> map = new HashMap<>();
        scanDirectory(resourceManager, this.directory, this.gson, map);
        return map;
    }

    public static void scanDirectory(class_3300 resourceManager, String name, Gson gson, Map<class_2960, JsonElement> output) {
        class_7654 filetoidconverter = class_7654.method_45114(name);

        for (Map.Entry<class_2960, class_3298> entry : filetoidconverter.method_45113(resourceManager).entrySet()) {
            class_2960 resourcelocation = entry.getKey();
            class_2960 resourcelocation1 = filetoidconverter.method_45115(resourcelocation);

            try (Reader reader = entry.getValue().method_43039()) {
                JsonElement jsonelement = class_3518.method_15276(gson, reader, JsonElement.class);
                JsonElement jsonelement1 = output.put(resourcelocation1, jsonelement);
                if (jsonelement1 != null) {
                    throw new IllegalStateException("Duplicate data file ignored with ID " + resourcelocation1);
                }
            } catch (IllegalArgumentException | IOException | JsonParseException jsonparseexception) {
                LOGGER.error("Couldn't parse data file {} from {}", resourcelocation1, resourcelocation, jsonparseexception);
            }
        }
    }

    protected class_2960 getPreparedPath(class_2960 rl) {
        return rl.method_45136(this.directory + "/" + rl.method_12832() + ".json");
    }
}
