// SPDX-FileCopyrightText: 2023 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.datagen;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.datagen.MultiblockProvider;
import net.minecraft.class_2246;
import net.minecraft.class_3481;
import net.minecraft.class_7784;

public class DemoMultiblockProvider extends MultiblockProvider {
    public DemoMultiblockProvider(class_7784 packOutput, String modid) {
        super(packOutput, modid);
    }

    @Override
    public void buildMultiblocks() {
        this.add(this.modLoc("demo_tag"), new DenseMultiblockBuilder()
                .layer(
                        " WWW ",
                        "N G S",
                        "NG0GS",
                        "N G S",
                        " EEE "
                )
                .blockstate('N', () -> class_2246.field_10563, "[facing=north]")
                .blockstate('S', () -> class_2246.field_10563, "[facing=south]")
                .blockstate('W', () -> class_2246.field_10563, "[facing=west]")
                .blockstate('E', () -> class_2246.field_10563, "[facing=east]")
                .tag('G', class_3481.field_26983, () -> class_2246.field_27100)
                .block('0', () -> class_2246.field_10481)
        );

        this.add(this.modLoc("demo_block_entity"), new DenseMultiblockBuilder()
                .layer(" WWW ",
                        "NFXFS",
                        "NF0FS",
                        "NFKFS",
                        " EEE "
                )
                .blockstate('N', () -> class_2246.field_10563, "[facing=north]")
                .blockstate('S', () -> class_2246.field_10563, "[facing=south]")
                .blockstate('W', () -> class_2246.field_10563, "[facing=west]")
                .blockstate('E', () -> class_2246.field_10563, "[facing=east]")
                .block('F', () -> class_2246.field_10181)
                .blockstate('X', () -> class_2246.field_10481, "[rotation=2]")
                .blockstate('K', () -> class_2246.field_10481, "")
        );


        this.add(this.modLoc("demo_dense"), new DenseMultiblockBuilder()
                .layer(" WWW ",
                        "N   S",
                        "N 0 S",
                        "N   S",
                        " EEE "
                )
                .blockstate('N', () -> class_2246.field_10563, "[facing=north]")
                .blockstate('S', () -> class_2246.field_10563, "[facing=south]")
                .blockstate('W', () -> class_2246.field_10563, "[facing=west]")
                .blockstate('E', () -> class_2246.field_10563, "[facing=east]")
        );

        //test counts towards total blocks
        //Note that "t" and "s" will not render as red concrete / "remove block" blocks because they are not set to display air
        //  "a", however, will render the red concrete and show "remove block".
        this.add(this.modLoc("demo_predicate"), new DenseMultiblockBuilder()
                .layer(
                        " ttt ",
                        "t a t",
                        "ta0as",
                        "s a s",
                        " sss "
                )
                .block('0', () -> class_2246.field_10566)
                .predicate('t', Modonomicon.loc("non_solid"), false, () -> class_2246.field_10336)
                .predicate('s', Modonomicon.loc("non_solid"), true, () -> class_2246.field_10479)
                .predicate('a', Modonomicon.loc("non_solid"), true, () -> class_2246.field_10124)
        );

        //purpose of this is to test the ground layer padding generation on non-square blocks
        this.add(this.modLoc("test_non_square"),
                new DenseMultiblockBuilder()
                        .layer(
                                "       s   ",
                                "           ",
                                "ce  0     r",
                                "           ",
                                "       s   "
                        )
                        .block('c', () -> class_2246.field_10211)
                        .block('e', () -> class_2246.field_10474)
                        .block('s', () -> class_2246.field_10102)
                        .block('r', () -> class_2246.field_9999)
                        .block('0', () -> class_2246.field_16332)
                        .build()
        );

        this.add(this.modLoc("demo_fluid"), new DenseMultiblockBuilder()
                .layer(
                        " LLL ",
                        "W   W",
                        "W 0 W",
                        "W   W",
                        " LLL "
                )
                .block('L', () -> class_2246.field_10164)
                .block('W', () -> class_2246.field_10382)
        );

        this.add(this.modLoc("demo_transparency"), new DenseMultiblockBuilder()
                .layer(
                        "G F",
                        " 0 ",
                        "I C"
                )
                .block('G', () -> class_2246.field_10285)
                .block('F', () -> class_2246.field_10077)
                .block('I', () -> class_2246.field_10576)
                .block('C', () -> class_2246.field_23985)
        );

    }
}
