/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.fluid;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_9326;

public class FabricFluidHolder implements FluidHolder {

    private final FluidVariant fluidVariant;
    private int amount;

    public FabricFluidHolder(FluidHolder fluid) {
        this(fluid.getFluid().comp_349(), fluid.getAmount(), fluid.getComponents());
    }

    public FabricFluidHolder(class_3611 fluid, int amount, class_9326 components) {
        this(FluidVariant.of(fluid, components), amount);
    }

    public FabricFluidHolder(FluidVariant fluidVariant, int amount) {
        this.fluidVariant = fluidVariant;
        this.amount = amount;
    }

    public static FabricFluidHolder empty() {
        return new FabricFluidHolder(FluidVariant.blank(), 0);
    }

    public FluidVariant toVariant() {
        return FluidVariant.of(this.getFluid().comp_349(), this.getComponents());
    }

    @Override
    public class_6880<class_3611> getFluid() {
        return this.fluidVariant.getRegistryEntry();
    }

    @Override
    public boolean isEmpty() {
        return this.amount <= 0;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(int amount) {
        this.amount = amount;
    }


    @Override
    public class_9326 getComponents() {
        return this.fluidVariant.getComponents();
    }


    @Override
    public FluidHolder copy() {
        return new FabricFluidHolder(this.getFluid().comp_349(), this.getAmount(), this.getComponents());
    }
}
