// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.integration;

import com.klikli_dev.modonomicon.networking.OpenBookOnClientMessage;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.registry.DataComponentRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3715;
import net.minecraft.class_3722;
import net.minecraft.class_3965;

public class LecternIntegration {

    public static class_1269 rightClick(class_1657 player, class_1937 pLevel, class_1268 hand, class_3965 hit) {
        class_2338 pos = hit.method_17777();
        class_2680 state = pLevel.method_8320(pos);

        if (!(pLevel.method_8321(pos) instanceof class_3722 lectern))
            return class_1269.field_5811;

        if (state.method_11654(class_3715.field_17366)) {
            if (player.method_5715()) {
                takeBook(player, lectern);
            } else {
                if (!pLevel.field_9236 && player instanceof class_3222 serverPlayer) {
                    if (openBook(serverPlayer, lectern.method_17520()))
                        return class_1269.field_5812;
                }
            }
        } else {
            class_1799 stack = player.method_5998(hand);
            if (stack.method_58694(DataComponentRegistry.BOOK_ID.get()) != null) {
                if (class_3715.method_17472(player, pLevel, pos, state, stack)) {
                    return class_1269.field_5812;
                }
            }
        }
        return class_1269.field_5811;
    }

    private static boolean openBook(class_3222 player, class_1799 stack) {
        var bookId = stack.method_58694(DataComponentRegistry.BOOK_ID.get());
        if (bookId != null) {
            Services.NETWORK.sendTo(player, new OpenBookOnClientMessage(bookId));
            return true;
        }
        return false;
    }

    private static void takeBook(class_1657 player, class_3722 lectern) {
        class_1799 stack = lectern.method_17520();
        var bookId = stack.method_58694(DataComponentRegistry.BOOK_ID.get());
        if (bookId != null) {
            lectern.method_17513(class_1799.field_8037);
            class_3715.method_17473(player, lectern.method_10997(), lectern.method_11016(), lectern.method_11010(), false);
            if (!player.method_31548().method_7394(stack)) {
                player.method_7328(stack, false);
            }
        }
    }
}
