/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.item;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Tooltips;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.registry.DataComponentRegistry;
import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ModonomiconItem extends class_1792 {
    public ModonomiconItem(class_1793 pProperties) {
        super(pProperties);
    }

    public static Book getBook(class_1799 stack) {
        class_2960 res = getBookId(stack);
        if (res == null) {
            return null;
        }
        return BookDataManager.get().getBook(res);
    }

    public static class_2960 getBookId(class_1799 stack) {
        return stack.method_58694(DataComponentRegistry.BOOK_ID.get());
    }

    /**
     * Sets the book state to closed using data components. Should be called server-side.
     */
    public static void setBookClosed(class_1799 stack) {
        if (stack != null) {
            stack.method_57379(DataComponentRegistry.BOOK_OPEN.get(), false);
        }
    }

    /**
     * Returns true if the book is open, false if closed or not set.
     */
    public static boolean isBookOpen(class_1799 stack) {
        if (stack != null && stack.method_57826(DataComponentRegistry.BOOK_OPEN.get())) {
            Boolean val = stack.method_58694(DataComponentRegistry.BOOK_OPEN.get());
            return Boolean.TRUE.equals(val);
        }
        return false;
    }

    public Book getBookFor(class_1799 stack) {
        return getBook(stack);
    }

    @Override
    public @NotNull class_1269 method_7836(class_1937 pLevel, class_1657 pPlayer, @NotNull class_1268 pUsedHand) {
        var itemInHand = pPlayer.method_5998(pUsedHand);

        // Set the book state to open using data components
        itemInHand.method_57379(DataComponentRegistry.BOOK_OPEN.get(), true);

        if (pLevel.field_9236) {
            if (itemInHand.method_58694(DataComponentRegistry.BOOK_ID.get()) != null) {
                var book = getBook(itemInHand);

                BookGuiManager.get().openBook(BookAddress.defaultFor(book));
            } else {
                Modonomicon.LOG.error("ModonomiconItem: ItemStack has no tag!");
            }
        }

        return class_1269.field_5812;
    }

    @Override
    public class_2561 method_7864(class_1799 pStack) {
        Book book = this.getBookFor(pStack);
        if (book != null) {
            return class_2561.method_43471(book.getName());
        }

        return super.method_7864(pStack);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void method_67187(@NotNull class_1799 itemStack, @NotNull class_9635 tooltipContext, @NotNull class_10712 tooltipDisplay, @NotNull Consumer<class_2561> consumer, @NotNull class_1836 tooltipFlag) {
        super.method_67187(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);

        Book book = getBook(itemStack);
        if (book != null) {
            if (tooltipFlag.method_8035()) {
                consumer.accept(class_2561.method_43470("Book ID: ").method_27692(class_124.field_1063)
                        .method_10852(class_2561.method_43470(book.getId().toString()).method_27692(class_124.field_1061)));
            }

            if (!book.getTooltip().isBlank()) {
                consumer.accept(class_2561.method_43471(book.getTooltip()).method_27692(class_124.field_1080));
            }
        } else {
            var compound = new class_2487();
            for (var entry : itemStack.method_57353()) {
                var tag = entry.method_57943(class_2509.field_11560).getOrThrow();
                var key = class_7923.field_49658.method_10221(entry.comp_2443());

                compound.method_10566(key.toString(), tag);
            }

            consumer.accept(class_2561.method_43469(Tooltips.ITEM_NO_BOOK_FOUND_FOR_STACK, class_2512.method_32270(compound))
                    .method_27692(class_124.field_1063));
        }
    }
}
