/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.events.EntryFirstReadEvent;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.events.ModonomiconEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class BookEntryReadMessage implements Message {

    public static final class_9154<BookEntryReadMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "book_entry_read"));

    public static final class_9139<class_9129, BookEntryReadMessage> STREAM_CODEC = class_9139.method_56435(
            class_2960.field_48267,
            (m) -> m.bookId,
            class_2960.field_48267,
            (m) -> m.entryId,
            BookEntryReadMessage::new
    );

    public class_2960 bookId;
    public class_2960 entryId;

    public BookEntryReadMessage(class_2960 bookId, class_2960 entryId) {
        this.bookId = bookId;
        this.entryId = entryId;
    }

    @Override
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var entry = BookDataManager.get().getBook(this.bookId).getEntry(this.entryId);
        //unlock page, then update the unlock capability, finally sync.
        if (BookUnlockStateManager.get().readFor(player, entry)) {
            BookUnlockStateManager.get().updateAndSyncFor(player);
            ModonomiconEvents.server().entryFirstRead(new EntryFirstReadEvent(entry.getBook().getId(), entry.getId()));
        }
    }
}
