/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.registry;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.item.ModonomiconItem;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ItemRegistry {
    public static final RegistrationProvider<class_1792> ITEMS = RegistrationProvider.get(class_7924.field_41197, Modonomicon.MOD_ID);

    public static final RegistryObject<class_1792> MODONOMICON =
            register("modonomicon", (properties) -> new ModonomiconItem(properties.method_7889(1)));

    //Dummy items for default models
    public static final RegistryObject<class_1792> MODONOMICON_BLUE =
            register("modonomicon_blue", class_1792::new);
    public static final RegistryObject<class_1792> MODONOMICON_GREEN =
            register("modonomicon_green", class_1792::new);
    public static final RegistryObject<class_1792> MODONOMICON_PURPLE =
            register("modonomicon_purple", class_1792::new);
    public static final RegistryObject<class_1792> MODONOMICON_RED =
            register("modonomicon_red", class_1792::new);
    public static final RegistryObject<class_1792> LEAFLET =
            register("leaflet", (properties) -> new class_1792(properties.method_7889(1)));

    // Called in the mod initializer / constructor in order to make sure that items are registered
    public static void load() {
    }


    public static <I extends class_1792> RegistryObject<I> register(final String name, final Function<class_1792.class_1793, ? extends I> itemConstructor) {
        return ITEMS.register(name, () -> itemConstructor.apply(new class_1792.class_1793().method_63686(class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(Modonomicon.MOD_ID, name)))));
    }

}
