/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.util;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_7764;
import net.minecraft.class_8690;

public class GuiGraphicsExt {

    public static void drawTiledSprite(class_332 guiGraphics, final int tiledWidth, final int tiledHeight, int color, int scaledAmount, class_1058 sprite, int posX, int posY) {


        class_7764 spriteContents = sprite.method_45851();
        class_8690.class_8694 tileScaling = new class_8690.class_8694(spriteContents.method_45807(), spriteContents.method_45815());

        posY = posY + tiledHeight - scaledAmount;

        guiGraphics.method_44379(posX, posY, posX + tiledWidth, posY + scaledAmount);
        {
            guiGraphics.method_52712(
                    class_10799.field_56883,
                    sprite,
                    posX,
                    posY,
                    tiledWidth,
                    scaledAmount,
                    0,
                    0,
                    tileScaling.comp_1644(),
                    tileScaling.comp_1645(),
                    tileScaling.comp_1644(),
                    tileScaling.comp_1645(),
                    color
            );
        }
        guiGraphics.method_44380();
    }

    /**
     * drawString for rendering at float coordinates.
     */
    public static void drawString(class_332 guiGraphics, class_327 font, class_2561 component, float x, float y, int color, boolean drawShadow) {
            int x1i = class_3532.method_15375(x);
            int y1i = class_3532.method_15375(y);
            float x1f = x-x1i;
            float y1f = y-y1i;

        guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate(x1f, y1f);
            guiGraphics.method_51439(font, component, x1i, y1i, color, drawShadow);
        guiGraphics.method_51448().popMatrix();
    }

    /**
     * drawString for rendering at float coordinates.
     */
    public static void drawString(class_332 guiGraphics, class_327 font, String string, float x, float y, int color, boolean drawShadow) {
        int x1i = class_3532.method_15375(x);
        int y1i = class_3532.method_15375(y);
        float x1f = x-x1i;
        float y1f = y-y1i;

        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate(x1f, y1f);
        guiGraphics.method_51433(font, string, x1i, y1i, color, drawShadow);
        guiGraphics.method_51448().popMatrix();
    }

    /**
     * drawString for rendering at float coordinates.
     */
    public static void drawString(class_332 guiGraphics, class_327 font, class_5481 string, float x, float y, int color, boolean drawShadow) {
        int x1i = class_3532.method_15375(x);
        int y1i = class_3532.method_15375(y);
        float x1f = x-x1i;
        float y1f = y-y1i;

        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate(x1f, y1f);
        guiGraphics.method_51430(font, string, x1i, y1i, color, drawShadow);
        guiGraphics.method_51448().popMatrix();
    }


    /**
     * Draws a textured box of any size (smallest size is borderSize * 2 square)
     * based on a fixed size textured box with continuous borders and filler.
     * See Forge IForgeGuiGraphics
     *
     * @param texture       the ResourceLocation object that contains the desired image
     * @param pipeline      the render pipeline
     * @param x             x-axis offset
     * @param y             y-axis offset
     * @param u             bound resource location image x offset
     * @param v             bound resource location image y offset
     * @param width         the desired box width
     * @param height        the desired box height
     * @param textureWidth  the width of the box texture in the resource location image
     * @param textureHeight the height of the box texture in the resource location image
     * @param borderSize    the size of the box's borders
     */
    public static void blitWithBorder(class_332 guiGraphics, RenderPipeline pipeline, class_2960 texture, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize) {
        blitWithBorder(guiGraphics, pipeline, texture, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize);
    }

    /**
     * Draws a textured box of any size (smallest size is borderSize * 2 square)
     * based on a fixed size textured box with continuous borders and filler.
     * See Forge IForgeGuiGraphics
     *
     * @param texture       the ResourceLocation object that contains the desired image
     * @param pipeline      the render pipeline
     * @param x             x-axis offset
     * @param y             y-axis offset
     * @param u             bound resource location image x offset
     * @param v             bound resource location image y offset
     * @param width         the desired box width
     * @param height        the desired box height
     * @param maxU          the width of the box texture in the resource location image
     * @param maxV          the height of the box texture in the resource location image
     * @param topBorder     the size of the box's top border
     * @param bottomBorder  the size of the box's bottom border
     * @param leftBorder    the size of the box's left border
     * @param rightBorder   the size of the box's right border
     */
    public static void blitWithBorder(class_332 guiGraphics, RenderPipeline pipeline, class_2960 texture, int x, int y, int u, int v, int width, int height, int maxU, int maxV, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        int fillerWidth = maxU - leftBorder - rightBorder;
        int fillerHeight = maxV - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;

        // Draw Border
        // Top Left
        guiGraphics.method_25290(pipeline, texture, x, y, u, v, leftBorder, topBorder, 256, 256);
        // Top Right
        guiGraphics.method_25290(pipeline, texture, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, 256, 256);
        // Bottom Left
        guiGraphics.method_25290(pipeline, texture, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, 256, 256);
        // Bottom Right
        guiGraphics.method_25290(pipeline, texture, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, 256, 256);

        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); i++) {
            // Top Border
            guiGraphics.method_25290(pipeline, texture, x + leftBorder + (i * fillerWidth), y, u + leftBorder, v, (i == xPasses ? remainderWidth : fillerWidth), topBorder, 256, 256);
            // Bottom Border
            guiGraphics.method_25290(pipeline, texture, x + leftBorder + (i * fillerWidth), y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, (i == xPasses ? remainderWidth : fillerWidth), bottomBorder, 256, 256);

            // Throw in some filler for good measure
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); j++)
                guiGraphics.method_25290(pipeline, texture, x + leftBorder + (i * fillerWidth), y + topBorder + (j * fillerHeight), u + leftBorder, v + topBorder, (i == xPasses ? remainderWidth : fillerWidth), (j == yPasses ? remainderHeight : fillerHeight), 256, 256);
        }

        // Side Borders
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); j++) {
            // Left Border
            guiGraphics.method_25290(pipeline, texture, x, y + topBorder + (j * fillerHeight), u, v + topBorder, leftBorder, (j == yPasses ? remainderHeight : fillerHeight), 256, 256);
            // Right Border
            guiGraphics.method_25290(pipeline, texture, x + leftBorder + canvasWidth, y + topBorder + (j * fillerHeight), u + leftBorder + fillerWidth, v + topBorder, rightBorder, (j == yPasses ? remainderHeight : fillerHeight), 256, 256);
        }
    }

}
